/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.app.service.runtime;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.flowable.app.model.common.ResultListDataRepresentation;
import org.flowable.app.model.runtime.ProcessDefinitionRepresentation;
import org.flowable.app.service.exception.BadRequestException;
import org.flowable.app.service.exception.InternalServerErrorException;
import org.flowable.app.service.exception.NotFoundException;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.StartEvent;
import org.flowable.editor.language.json.converter.util.CollectionUtils;
import org.flowable.engine.RepositoryService;
import org.flowable.engine.common.api.FlowableObjectNotFoundException;
import org.flowable.engine.repository.Deployment;
import org.flowable.engine.repository.ProcessDefinition;
import org.flowable.engine.repository.ProcessDefinitionQuery;
import org.flowable.form.api.FormRepositoryService;
import org.flowable.form.model.FormField;
import org.flowable.form.model.FormModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class FlowableProcessDefinitionService {
    private static final Logger logger = LoggerFactory.getLogger(FlowableProcessDefinitionService.class);
    @Autowired
    protected RepositoryService repositoryService;
    @Autowired
    protected FormRepositoryService formRepositoryService;
    @Autowired
    protected ObjectMapper objectMapper;

    public FormModel getProcessDefinitionStartForm(HttpServletRequest request) {
        String[] requestInfoArray = this.parseRequest(request);
        String processDefinitionId = this.getProcessDefinitionId(requestInfoArray, requestInfoArray.length - 2);
        ProcessDefinition processDefinition = this.repositoryService.getProcessDefinition(processDefinitionId);
        try {
            return this.getStartForm(processDefinition);
        }
        catch (FlowableObjectNotFoundException aonfe) {
            throw new NotFoundException("No process definition found with the given id: " + processDefinitionId);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ResultListDataRepresentation getProcessDefinitions(Boolean latest, String deploymentKey) {
        ProcessDefinitionQuery definitionQuery = this.repositoryService.createProcessDefinitionQuery();
        if (deploymentKey != null) {
            Deployment deployment = (Deployment)this.repositoryService.createDeploymentQuery().deploymentKey(deploymentKey).latest().singleResult();
            if (deployment == null) return new ResultListDataRepresentation(new ArrayList());
            definitionQuery.deploymentId(deployment.getId());
        } else if (latest != null && latest.booleanValue()) {
            definitionQuery.latestVersion();
        }
        List definitions = definitionQuery.list();
        return new ResultListDataRepresentation(this.convertDefinitionList(definitions));
    }

    protected FormModel getStartForm(ProcessDefinition processDefinition) {
        StartEvent startEvent;
        FormModel formModel = null;
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(processDefinition.getId());
        Process process = bpmnModel.getProcessById(processDefinition.getKey());
        FlowElement startElement = process.getInitialFlowElement();
        if (startElement instanceof StartEvent && StringUtils.isNotEmpty((CharSequence)(startEvent = (StartEvent)startElement).getFormKey())) {
            formModel = this.formRepositoryService.getFormModelByKeyAndParentDeploymentId(startEvent.getFormKey(), processDefinition.getDeploymentId(), processDefinition.getTenantId());
        }
        if (formModel == null) {
            throw new NotFoundException("Process definition does not have a form defined: " + processDefinition.getId());
        }
        return formModel;
    }

    protected ProcessDefinition getProcessDefinitionFromRequest(String[] requestInfoArray, boolean isTableRequest) {
        int paramPosition = requestInfoArray.length - 3;
        if (isTableRequest) {
            --paramPosition;
        }
        String processDefinitionId = this.getProcessDefinitionId(requestInfoArray, paramPosition);
        ProcessDefinition processDefinition = this.repositoryService.getProcessDefinition(processDefinitionId);
        return processDefinition;
    }

    protected FormField getFormFieldFromRequest(String[] requestInfoArray, ProcessDefinition processDefinition, boolean isTableRequest) {
        FormModel form = this.getStartForm(processDefinition);
        int paramPosition = requestInfoArray.length - 1;
        if (isTableRequest) {
            --paramPosition;
        }
        String fieldVariable = requestInfoArray[paramPosition];
        List allFields = form.listAllFields();
        FormField selectedField = null;
        if (CollectionUtils.isNotEmpty((Collection)allFields)) {
            for (FormField formFieldRepresentation : allFields) {
                if (!formFieldRepresentation.getId().equalsIgnoreCase(fieldVariable)) continue;
                selectedField = formFieldRepresentation;
            }
        }
        if (selectedField == null) {
            throw new NotFoundException("Field could not be found in start form definition " + fieldVariable);
        }
        return selectedField;
    }

    protected List<ProcessDefinitionRepresentation> convertDefinitionList(List<ProcessDefinition> definitions) {
        ArrayList<ProcessDefinitionRepresentation> result = new ArrayList<ProcessDefinitionRepresentation>();
        if (CollectionUtils.isNotEmpty(definitions)) {
            for (ProcessDefinition processDefinition : definitions) {
                ProcessDefinitionRepresentation rep = new ProcessDefinitionRepresentation(processDefinition);
                result.add(rep);
            }
        }
        return result;
    }

    protected String[] parseRequest(HttpServletRequest request) {
        String requestURI = request.getRequestURI();
        String[] requestInfoArray = requestURI.split("/");
        if (requestInfoArray.length < 2) {
            throw new BadRequestException("Start form request is not valid " + requestURI);
        }
        return requestInfoArray;
    }

    protected String getProcessDefinitionId(String[] requestInfoArray, int position) {
        String processDefinitionVariable = requestInfoArray[position];
        String processDefinitionId = null;
        try {
            processDefinitionId = URLDecoder.decode(processDefinitionVariable, "UTF-8");
        }
        catch (Exception e) {
            logger.error("Error decoding process definition {}", (Object)processDefinitionVariable, (Object)e);
            throw new InternalServerErrorException("Error decoding process definition " + processDefinitionVariable);
        }
        return processDefinitionId;
    }
}

