/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.app.service.runtime;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.List;
import org.flowable.app.model.common.UserRepresentation;
import org.flowable.app.model.runtime.TaskRepresentation;
import org.flowable.app.security.SecurityUtils;
import org.flowable.app.service.api.UserCache;
import org.flowable.app.service.exception.BadRequestException;
import org.flowable.app.service.exception.NotFoundException;
import org.flowable.app.service.exception.NotPermittedException;
import org.flowable.app.service.runtime.FlowableAbstractTaskService;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.history.HistoricIdentityLink;
import org.flowable.engine.task.IdentityLink;
import org.flowable.engine.task.Task;
import org.flowable.engine.task.TaskInfo;
import org.flowable.engine.task.TaskQuery;
import org.flowable.idm.api.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class FlowableTaskActionService
extends FlowableAbstractTaskService {
    private static final Logger logger = LoggerFactory.getLogger(FlowableTaskActionService.class);

    public void completeTask(String taskId) {
        User currentUser = SecurityUtils.getCurrentUserObject();
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        if (task == null) {
            throw new NotFoundException("Task with id: " + taskId + " does not exist");
        }
        if (!this.permissionService.isTaskOwnerOrAssignee(currentUser, task) && !this.permissionService.validateIfUserIsInitiatorAndCanCompleteTask(currentUser, task)) {
            throw new NotPermittedException();
        }
        try {
            this.taskService.complete(task.getId());
        }
        catch (FlowableException e) {
            logger.error("Error completing task {}", (Object)taskId, (Object)e);
            throw new BadRequestException("Task " + taskId + " can't be completed", (Throwable)e);
        }
    }

    public TaskRepresentation assignTask(String taskId, ObjectNode requestNode) {
        String assigneeIdString;
        User currentUser = SecurityUtils.getCurrentUserObject();
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        if (task == null) {
            throw new NotFoundException("Task with id: " + taskId + " does not exist");
        }
        this.checkTaskPermissions(taskId, currentUser, task);
        if (requestNode.get("assignee") != null) {
            assigneeIdString = requestNode.get("assignee").asText();
            UserCache.CachedUser cachedUser = this.userCache.getUser(assigneeIdString);
            if (cachedUser == null) {
                throw new BadRequestException("Invalid assignee id");
            }
        } else {
            throw new BadRequestException("Assignee is required");
        }
        this.assignTask(currentUser, task, assigneeIdString);
        task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        TaskRepresentation rep = new TaskRepresentation(task);
        this.fillPermissionInformation(rep, (TaskInfo)task, currentUser);
        this.populateAssignee((TaskInfo)task, rep);
        rep.setInvolvedPeople(this.getInvolvedUsers(taskId));
        return rep;
    }

    public void involveUser(String taskId, ObjectNode requestNode) {
        String userId;
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        if (task == null) {
            throw new NotFoundException("Task with id: " + taskId + " does not exist");
        }
        User currentUser = SecurityUtils.getCurrentUserObject();
        this.permissionService.validateReadPermissionOnTask(currentUser, task.getId());
        if (requestNode.get("userId") != null) {
            userId = requestNode.get("userId").asText();
            UserCache.CachedUser user = this.userCache.getUser(userId);
            if (user == null) {
                throw new BadRequestException("Invalid user id");
            }
        } else {
            throw new BadRequestException("User id is required");
        }
        this.taskService.addUserIdentityLink(taskId, userId, "participant");
    }

    public void removeInvolvedUser(String taskId, ObjectNode requestNode) {
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        if (task == null) {
            throw new NotFoundException("Task with id: " + taskId + " does not exist");
        }
        this.permissionService.validateReadPermissionOnTask(SecurityUtils.getCurrentUserObject(), task.getId());
        String assigneeString = null;
        if (requestNode.get("userId") != null) {
            String userId = requestNode.get("userId").asText();
            if (this.userCache.getUser(userId) == null) {
                throw new BadRequestException("Invalid user id");
            }
            assigneeString = String.valueOf(userId);
        } else if (requestNode.get("email") != null) {
            String email;
            assigneeString = email = requestNode.get("email").asText();
        } else {
            throw new BadRequestException("User id or email is required");
        }
        this.taskService.deleteUserIdentityLink(taskId, assigneeString, "participant");
    }

    public void claimTask(String taskId) {
        User currentUser = SecurityUtils.getCurrentUserObject();
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        if (task == null) {
            throw new NotFoundException("Task with id: " + taskId + " does not exist");
        }
        this.permissionService.validateReadPermissionOnTask(currentUser, task.getId());
        try {
            this.taskService.claim(task.getId(), String.valueOf(currentUser.getId()));
        }
        catch (FlowableException e) {
            throw new BadRequestException("Task " + taskId + " can't be claimed", (Throwable)e);
        }
    }

    protected void checkTaskPermissions(String taskId, User currentUser, Task task) {
        this.permissionService.validateReadPermissionOnTask(currentUser, task.getId());
    }

    protected String validateEmail(ObjectNode requestNode) {
        String email;
        String string = email = requestNode.get("email") != null ? requestNode.get("email").asText() : null;
        if (email == null) {
            throw new BadRequestException("Email is mandatory");
        }
        return email;
    }

    protected void assignTask(User currentUser, Task task, String assigneeIdString) {
        try {
            String oldAssignee = task.getAssignee();
            this.taskService.setAssignee(task.getId(), assigneeIdString);
            this.addIdentiyLinkForUser(task, oldAssignee, "participant");
            String currentUserIdString = String.valueOf(currentUser.getId());
            this.addIdentiyLinkForUser(task, currentUserIdString, "participant");
        }
        catch (FlowableException e) {
            throw new BadRequestException("Task " + task.getId() + " can't be assigned", (Throwable)e);
        }
    }

    protected void addIdentiyLinkForUser(Task task, String userId, String linkType) {
        List identityLinks = this.taskService.getIdentityLinksForTask(task.getId());
        boolean isOldUserInvolved = false;
        for (IdentityLink identityLink : identityLinks) {
            if (!userId.equals(identityLink.getUserId()) || !identityLink.getType().equals("participant") && !identityLink.getType().equals("candidate")) continue;
            isOldUserInvolved = true;
        }
        if (!isOldUserInvolved) {
            this.taskService.addUserIdentityLink(task.getId(), userId, linkType);
        }
    }

    protected void populateAssignee(TaskInfo task, TaskRepresentation rep) {
        UserCache.CachedUser cachedUser;
        if (task.getAssignee() != null && (cachedUser = this.userCache.getUser(task.getAssignee())) != null && cachedUser.getUser() != null) {
            rep.setAssignee(new UserRepresentation(cachedUser.getUser()));
        }
    }

    protected List<UserRepresentation> getInvolvedUsers(String taskId) {
        List idLinks = this.historyService.getHistoricIdentityLinksForTask(taskId);
        ArrayList<UserRepresentation> result = new ArrayList<UserRepresentation>(idLinks.size());
        for (HistoricIdentityLink link : idLinks) {
            UserCache.CachedUser cachedUser;
            if (link.getUserId() == null || "assignee".equals(link.getType()) || (cachedUser = this.userCache.getUser(link.getUserId())) == null || cachedUser.getUser() == null) continue;
            result.add(new UserRepresentation(cachedUser.getUser()));
        }
        return result;
    }
}

