/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.app.service.runtime;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.flowable.app.model.runtime.CompleteFormRepresentation;
import org.flowable.app.model.runtime.ProcessInstanceVariableRepresentation;
import org.flowable.app.model.runtime.SaveFormRepresentation;
import org.flowable.app.security.SecurityUtils;
import org.flowable.app.service.exception.NotFoundException;
import org.flowable.app.service.exception.NotPermittedException;
import org.flowable.app.service.runtime.PermissionService;
import org.flowable.engine.HistoryService;
import org.flowable.engine.RepositoryService;
import org.flowable.engine.TaskService;
import org.flowable.engine.history.HistoricTaskInstance;
import org.flowable.engine.history.HistoricVariableInstance;
import org.flowable.engine.task.Task;
import org.flowable.engine.task.TaskQuery;
import org.flowable.form.api.FormRepositoryService;
import org.flowable.form.api.FormService;
import org.flowable.form.model.FormModel;
import org.flowable.idm.api.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class FlowableTaskFormService {
    private static final Logger logger = LoggerFactory.getLogger(FlowableTaskFormService.class);
    @Autowired
    protected TaskService taskService;
    @Autowired
    protected RepositoryService repositoryService;
    @Autowired
    protected HistoryService historyService;
    @Autowired
    protected FormRepositoryService formRepositoryService;
    @Autowired
    protected FormService formService;
    @Autowired
    protected PermissionService permissionService;
    @Autowired
    protected ObjectMapper objectMapper;

    public FormModel getTaskForm(String taskId) {
        HistoricTaskInstance task = this.permissionService.validateReadPermissionOnTask(SecurityUtils.getCurrentUserObject(), taskId);
        return this.taskService.getTaskFormModel(task.getId());
    }

    public void saveTaskForm(String taskId, SaveFormRepresentation saveFormRepresentation) {
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        if (task == null) {
            throw new NotFoundException("Task not found with id: " + taskId);
        }
        this.checkCurrentUserCanModifyTask(task);
        this.formService.saveFormInstanceByFormModelId(saveFormRepresentation.getValues(), saveFormRepresentation.getFormId(), taskId, task.getProcessInstanceId());
    }

    public void completeTaskForm(String taskId, CompleteFormRepresentation completeTaskFormRepresentation) {
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        if (task == null) {
            throw new NotFoundException("Task not found with id: " + taskId);
        }
        this.checkCurrentUserCanModifyTask(task);
        this.taskService.completeTaskWithForm(taskId, completeTaskFormRepresentation.getFormId(), completeTaskFormRepresentation.getOutcome(), completeTaskFormRepresentation.getValues());
    }

    public List<ProcessInstanceVariableRepresentation> getProcessInstanceVariables(String taskId) {
        HistoricTaskInstance task = this.permissionService.validateReadPermissionOnTask(SecurityUtils.getCurrentUserObject(), taskId);
        List historicVariables = this.historyService.createHistoricVariableInstanceQuery().processInstanceId(task.getProcessInstanceId()).list();
        HashMap<String, ProcessInstanceVariableRepresentation> processInstanceVariables = new HashMap<String, ProcessInstanceVariableRepresentation>();
        for (HistoricVariableInstance historicVariableInstance : historicVariables) {
            ProcessInstanceVariableRepresentation processInstanceVariableRepresentation = new ProcessInstanceVariableRepresentation(historicVariableInstance.getVariableName(), historicVariableInstance.getVariableTypeName(), historicVariableInstance.getValue());
            processInstanceVariables.put(historicVariableInstance.getId(), processInstanceVariableRepresentation);
        }
        ArrayList<ProcessInstanceVariableRepresentation> processInstanceVariableRepresenations = new ArrayList<ProcessInstanceVariableRepresentation>(processInstanceVariables.values());
        return processInstanceVariableRepresenations;
    }

    private void checkCurrentUserCanModifyTask(Task task) {
        User currentUser = SecurityUtils.getCurrentUserObject();
        if (!this.permissionService.isTaskOwnerOrAssignee(currentUser, task.getId()) && !this.permissionService.validateIfUserIsInitiatorAndCanCompleteTask(currentUser, task)) {
            throw new NotPermittedException();
        }
    }
}

