/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.app.service.runtime;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.flowable.app.model.common.UserRepresentation;
import org.flowable.app.model.runtime.TaskRepresentation;
import org.flowable.app.model.runtime.TaskUpdateRepresentation;
import org.flowable.app.security.SecurityUtils;
import org.flowable.app.service.api.UserCache;
import org.flowable.app.service.exception.NotFoundException;
import org.flowable.app.service.runtime.FlowableAbstractTaskService;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.history.HistoricIdentityLink;
import org.flowable.engine.history.HistoricTaskInstance;
import org.flowable.engine.repository.ProcessDefinition;
import org.flowable.engine.task.Task;
import org.flowable.engine.task.TaskInfo;
import org.flowable.engine.task.TaskQuery;
import org.flowable.idm.api.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class FlowableTaskService
extends FlowableAbstractTaskService {
    private static final Logger logger = LoggerFactory.getLogger(FlowableTaskService.class);

    public TaskRepresentation getTask(String taskId, HttpServletResponse response) {
        User currentUser = SecurityUtils.getCurrentUserObject();
        HistoricTaskInstance task = this.permissionService.validateReadPermissionOnTask(currentUser, taskId);
        ProcessDefinition processDefinition = null;
        if (StringUtils.isNotEmpty((CharSequence)task.getProcessDefinitionId())) {
            try {
                processDefinition = this.repositoryService.getProcessDefinition(task.getProcessDefinitionId());
            }
            catch (FlowableException e) {
                logger.error("Error getting process definition {}", (Object)task.getProcessDefinitionId(), (Object)e);
            }
        }
        TaskRepresentation rep = new TaskRepresentation((TaskInfo)task, processDefinition);
        this.fillPermissionInformation(rep, (TaskInfo)task, currentUser);
        this.populateAssignee((TaskInfo)task, rep);
        rep.setInvolvedPeople(this.getInvolvedUsers(taskId));
        return rep;
    }

    protected void populateAssignee(TaskInfo task, TaskRepresentation rep) {
        UserCache.CachedUser cachedUser;
        if (task.getAssignee() != null && (cachedUser = this.userCache.getUser(task.getAssignee())) != null && cachedUser.getUser() != null) {
            rep.setAssignee(new UserRepresentation(cachedUser.getUser()));
        }
    }

    protected List<UserRepresentation> getInvolvedUsers(String taskId) {
        List idLinks = this.historyService.getHistoricIdentityLinksForTask(taskId);
        ArrayList<UserRepresentation> result = new ArrayList<UserRepresentation>(idLinks.size());
        for (HistoricIdentityLink link : idLinks) {
            UserCache.CachedUser cachedUser;
            if (link.getUserId() == null || "assignee".equals(link.getType()) || (cachedUser = this.userCache.getUser(link.getUserId())) == null || cachedUser.getUser() == null) continue;
            result.add(new UserRepresentation(cachedUser.getUser()));
        }
        return result;
    }

    public TaskRepresentation updateTask(String taskId, TaskUpdateRepresentation updated) {
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        if (task == null) {
            throw new NotFoundException("Task with id: " + taskId + " does not exist");
        }
        this.permissionService.validateReadPermissionOnTask(SecurityUtils.getCurrentUserObject(), task.getId());
        if (updated.isNameSet()) {
            task.setName(updated.getName());
        }
        if (updated.isDescriptionSet()) {
            task.setDescription(updated.getDescription());
        }
        if (updated.isDueDateSet()) {
            task.setDueDate(updated.getDueDate());
        }
        this.taskService.saveTask(task);
        return new TaskRepresentation(task);
    }
}

