/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.app.service.runtime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.flowable.app.service.exception.NotFoundException;
import org.flowable.app.service.exception.NotPermittedException;
import org.flowable.app.service.idm.RemoteIdmService;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.ExtensionElement;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.UserTask;
import org.flowable.content.api.ContentItem;
import org.flowable.editor.language.json.converter.util.CollectionUtils;
import org.flowable.engine.HistoryService;
import org.flowable.engine.RepositoryService;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.TaskService;
import org.flowable.engine.history.HistoricProcessInstance;
import org.flowable.engine.history.HistoricProcessInstanceQuery;
import org.flowable.engine.history.HistoricTaskInstance;
import org.flowable.engine.history.HistoricTaskInstanceQuery;
import org.flowable.engine.task.Task;
import org.flowable.engine.task.TaskQuery;
import org.flowable.idm.api.Group;
import org.flowable.idm.api.User;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class PermissionService {
    @Autowired
    protected TaskService taskService;
    @Autowired
    protected RuntimeService runtimeService;
    @Autowired
    protected RepositoryService repositoryService;
    @Autowired
    protected HistoryService historyService;
    @Autowired
    protected RemoteIdmService remoteIdmService;

    public HistoricTaskInstance validateReadPermissionOnTask(User user, String taskId) {
        boolean hasReadPermissionOnProcessInstance;
        HistoricTaskInstance task;
        List tasks = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskId(taskId)).taskInvolvedUser(String.valueOf(user.getId()))).list();
        if (CollectionUtils.isNotEmpty((Collection)tasks)) {
            return (HistoricTaskInstance)tasks.get(0);
        }
        HistoricTaskInstanceQuery historicTaskInstanceQuery = this.historyService.createHistoricTaskInstanceQuery();
        historicTaskInstanceQuery.taskId(taskId);
        List<String> groupIds = this.getGroupIdsForUser(user);
        if (!groupIds.isEmpty()) {
            historicTaskInstanceQuery.taskCandidateGroupIn(this.getGroupIdsForUser(user));
        }
        if (CollectionUtils.isNotEmpty((Collection)(tasks = historicTaskInstanceQuery.list()))) {
            return (HistoricTaskInstance)tasks.get(0);
        }
        tasks = ((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskId(taskId)).list();
        if (CollectionUtils.isNotEmpty((Collection)tasks) && (task = (HistoricTaskInstance)tasks.get(0)) != null && task.getProcessInstanceId() != null && (hasReadPermissionOnProcessInstance = this.hasReadPermissionOnProcessInstance(user, task.getProcessInstanceId()))) {
            return task;
        }
        throw new NotPermittedException("User is not allowed to work with task " + taskId);
    }

    private List<String> getGroupIdsForUser(User user) {
        ArrayList<String> groupIds = new ArrayList<String>();
        for (Group group : this.remoteIdmService.getUser(user.getId()).getGroups()) {
            groupIds.add(String.valueOf(group.getId()));
        }
        return groupIds;
    }

    public boolean isTaskOwnerOrAssignee(User user, String taskId) {
        return this.isTaskOwnerOrAssignee(user, (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult());
    }

    public boolean isTaskOwnerOrAssignee(User user, Task task) {
        String currentUser = String.valueOf(user.getId());
        return currentUser.equals(task.getAssignee()) || currentUser.equals(task.getOwner());
    }

    public boolean validateIfUserIsInitiatorAndCanCompleteTask(User user, Task task) {
        HistoricProcessInstance historicProcessInstance;
        boolean canCompleteTask = false;
        if (task.getProcessInstanceId() != null && (historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult()) != null && StringUtils.isNotEmpty((CharSequence)historicProcessInstance.getStartUserId())) {
            String value;
            UserTask userTask;
            List extensionElements;
            BpmnModel bpmnModel;
            FlowElement flowElement;
            String processInstanceStartUserId = historicProcessInstance.getStartUserId();
            if (String.valueOf(user.getId()).equals(processInstanceStartUserId) && (flowElement = (bpmnModel = this.repositoryService.getBpmnModel(task.getProcessDefinitionId())).getFlowElement(task.getTaskDefinitionKey())) instanceof UserTask && CollectionUtils.isNotEmpty((Collection)(extensionElements = (List)(userTask = (UserTask)flowElement).getExtensionElements().get("initiator-can-complete"))) && StringUtils.isNotEmpty((CharSequence)(value = ((ExtensionElement)extensionElements.get(0)).getElementText())) && Boolean.valueOf(value).booleanValue()) {
                canCompleteTask = true;
            }
        }
        return canCompleteTask;
    }

    public boolean isInvolved(User user, String taskId) {
        return ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskId(taskId)).taskInvolvedUser(String.valueOf(user.getId()))).count() == 1L;
    }

    public boolean hasReadPermissionOnProcessInstance(User user, String processInstanceId) {
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        return this.hasReadPermissionOnProcessInstance(user, historicProcessInstance, processInstanceId);
    }

    public boolean hasReadPermissionOnProcessInstance(User user, HistoricProcessInstance historicProcessInstance, String processInstanceId) {
        if (historicProcessInstance == null) {
            throw new NotFoundException("Process instance not found for id " + processInstanceId);
        }
        if (historicProcessInstance.getStartUserId() != null && historicProcessInstance.getStartUserId().equals(user.getId())) {
            return true;
        }
        HistoricProcessInstanceQuery historicProcessInstanceQuery = this.historyService.createHistoricProcessInstanceQuery();
        historicProcessInstanceQuery.processInstanceId(processInstanceId);
        historicProcessInstanceQuery.involvedUser(user.getId());
        if (historicProcessInstanceQuery.count() > 0L) {
            return true;
        }
        HistoricTaskInstanceQuery historicTaskInstanceQuery = this.historyService.createHistoricTaskInstanceQuery();
        historicTaskInstanceQuery.processInstanceId(processInstanceId);
        historicTaskInstanceQuery.taskInvolvedUser(user.getId());
        if (historicTaskInstanceQuery.count() > 0L) {
            return true;
        }
        List<String> groupIds = this.getGroupIdsForUser(user);
        if (!groupIds.isEmpty()) {
            historicTaskInstanceQuery = this.historyService.createHistoricTaskInstanceQuery();
            ((HistoricTaskInstanceQuery)historicTaskInstanceQuery.processInstanceId(processInstanceId)).taskCandidateGroupIn(groupIds);
            return historicTaskInstanceQuery.count() > 0L;
        }
        return false;
    }

    public boolean canAddRelatedContentToTask(User user, String taskId) {
        this.validateReadPermissionOnTask(user, taskId);
        return true;
    }

    public boolean canAddRelatedContentToProcessInstance(User user, String processInstanceId) {
        return this.hasReadPermissionOnProcessInstance(user, processInstanceId);
    }

    public boolean canDownloadContent(User currentUserObject, ContentItem content) {
        if (content.getTaskId() != null) {
            this.validateReadPermissionOnTask(currentUserObject, content.getTaskId());
            return true;
        }
        if (content.getProcessInstanceId() != null) {
            return this.hasReadPermissionOnProcessInstance(currentUserObject, content.getProcessInstanceId());
        }
        return false;
    }

    public boolean hasWritePermissionOnRelatedContent(User user, ContentItem content) {
        if (content.getProcessInstanceId() != null) {
            return this.hasReadPermissionOnProcessInstance(user, content.getProcessInstanceId());
        }
        if (content.getCreatedBy() != null) {
            return content.getCreatedBy().equals(user.getId());
        }
        return false;
    }

    public boolean canDeleteProcessInstance(User currentUser, HistoricProcessInstance processInstance) {
        boolean canDelete = false;
        if (processInstance.getStartUserId() != null) {
            canDelete = processInstance.getStartUserId().equals(currentUser.getId());
        }
        return canDelete;
    }
}

