/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.archive.internal;

import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import org.hibernate.boot.archive.internal.ArchiveHelper;
import org.hibernate.boot.archive.internal.ExplodedArchiveDescriptor;
import org.hibernate.boot.archive.internal.JarFileBasedArchiveDescriptor;
import org.hibernate.boot.archive.internal.JarInputStreamBasedArchiveDescriptor;
import org.hibernate.boot.archive.internal.JarProtocolArchiveDescriptor;
import org.hibernate.boot.archive.spi.ArchiveDescriptor;
import org.hibernate.boot.archive.spi.ArchiveDescriptorFactory;
import org.hibernate.internal.util.StringHelper;

public class StandardArchiveDescriptorFactory
implements ArchiveDescriptorFactory {
    public static final StandardArchiveDescriptorFactory INSTANCE = new StandardArchiveDescriptorFactory();

    @Override
    public ArchiveDescriptor buildArchiveDescriptor(URL url) {
        return this.buildArchiveDescriptor(url, "");
    }

    @Override
    public ArchiveDescriptor buildArchiveDescriptor(URL url, String entry) {
        String protocol = url.getProtocol();
        if ("jar".equals(protocol)) {
            return new JarProtocolArchiveDescriptor(this, url, entry);
        }
        if (StringHelper.isEmpty(protocol) || "file".equals(protocol) || "vfszip".equals(protocol) || "vfsfile".equals(protocol)) {
            File file;
            try {
                String filePart = url.getFile();
                file = filePart != null && filePart.indexOf(32) != -1 ? new File(url.getFile()) : new File(url.toURI().getSchemeSpecificPart());
                if (!file.exists()) {
                    throw new IllegalArgumentException(String.format("File [%s] referenced by given URL [%s] does not exist", filePart, url.toExternalForm()));
                }
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Unable to visit JAR " + url + ". Cause: " + e.getMessage(), e);
            }
            if (file.isDirectory()) {
                return new ExplodedArchiveDescriptor(this, url, entry);
            }
            return new JarFileBasedArchiveDescriptor(this, url, entry);
        }
        return new JarInputStreamBasedArchiveDescriptor(this, url, entry);
    }

    @Override
    public URL getJarURLFromURLEntry(URL url, String entry) throws IllegalArgumentException {
        return ArchiveHelper.getJarURLFromURLEntry(url, entry);
    }

    @Override
    public URL getURLFromPath(String jarPath) {
        return ArchiveHelper.getURLFromPath(jarPath);
    }
}

