/*
 * Decompiled with CFR 0.152.
 */
package org.hiforce.lattice.cache.invoke;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.hiforce.lattice.cache.invoke.InvokeCacheThreadLocal;
import org.hiforce.lattice.exception.LatticeRuntimeException;
import org.hiforce.lattice.message.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InvokeCache {
    private static final Logger log = LoggerFactory.getLogger(InvokeCache.class);
    private static final Null NULL = new Null();
    private static final InvokeCacheThreadLocal INSTANCE = new InvokeCacheThreadLocal();
    private static final ThreadLocal<Boolean> INIT = new ThreadLocal();
    private final Map<Class<?>, Map<Object, Object>> cache = Maps.newHashMap();
    private final boolean needHoldRemoteCache = false;

    public static void main(String[] args) {
        System.out.println(InvokeCache.isThreadLocalInit());
        InvokeCache.instance().put(String.class, "rocky", "yu");
        InvokeCache.instance();
        System.out.println(InvokeCache.isThreadLocalInit());
        InvokeCache.initInvokeCache();
        System.out.println(InvokeCache.isThreadLocalInit());
    }

    InvokeCache() {
    }

    public static void initInvokeCache() {
        INIT.set(true);
        INSTANCE.get();
    }

    public static boolean isThreadLocalInit() {
        Boolean initialized = INIT.get();
        return null != initialized && initialized != false;
    }

    public static InvokeCache instance() {
        if (InvokeCache.isThreadLocalInit()) {
            return (InvokeCache)INSTANCE.get();
        }
        return new InvokeCache();
    }

    public static void forceClear() {
        INSTANCE.remove();
        INIT.remove();
    }

    public <T> void put(Class<? super T> klass, Object id, @Nullable T instance) {
        if (!InvokeCache.isThreadLocalInit()) {
            return;
        }
        if (instance != null) {
            Preconditions.checkArgument((boolean)klass.isInstance(instance), (Object)"incompatible class and instance");
        }
        Map<Object, Object> idToInstanceCache = this.getIdToInstanceCache(klass);
        if (instance != null) {
            idToInstanceCache.put(id, instance);
        } else {
            idToInstanceCache.put(id, NULL);
        }
        if (idToInstanceCache.size() > 1000) {
            log.warn("RemoteCache: idToInstanceCache too large! size = " + idToInstanceCache.size() + ", class = " + klass);
        }
    }

    public <T> void batchPut(Class<? super T> klass, List<?> ids, List<? extends T> instances) {
        if (!InvokeCache.isThreadLocalInit()) {
            return;
        }
        Preconditions.checkArgument((ids.size() == instances.size() ? 1 : 0) != 0, (Object)"incompatible ids and instances");
        Iterator<?> idsItr = ids.iterator();
        Iterator<T> instancesItr = instances.iterator();
        while (idsItr.hasNext()) {
            Object id = idsItr.next();
            T instance = instancesItr.next();
            if (instance != null) {
                Preconditions.checkArgument((boolean)klass.isInstance(instance), (Object)"incompatible class and instance");
            }
            this.put(klass, id, instance);
        }
    }

    @Nullable
    public <T> T get(Class<T> klass, Object id) {
        return this.get(klass, id, null);
    }

    @Nullable
    public <T> T get(Class<T> klass, Object id, @Nullable Callable<? extends T> callbackOnMiss) {
        Object ret = this.get0(klass, id, callbackOnMiss);
        if (ret == NULL) {
            return null;
        }
        return (T)ret;
    }

    @Nullable
    private <T> Object get0(Class<T> klass, Object id, @Nullable Callable<? extends T> callbackOnMiss) {
        Object ret;
        if (!InvokeCache.isThreadLocalInit()) {
            return null;
        }
        Map<Object, Object> idToInstanceCache = this.cache.get(klass);
        Object object = ret = idToInstanceCache == null ? null : idToInstanceCache.get(id);
        if (ret == NULL) {
            return NULL;
        }
        if (ret != null) {
            return ret;
        }
        if (callbackOnMiss != null) {
            try {
                T callbackRet = callbackOnMiss.call();
                this.put(klass, id, callbackRet);
                return callbackRet;
            }
            catch (Exception ex) {
                this.handleCallException(klass, Lists.newArrayList((Object[])new Object[]{id}), ex);
            }
        }
        return null;
    }

    @Nonnull
    public <T> List<T> batchGet(Class<T> klass, List<?> ids) {
        return this.batchGet(klass, ids, null);
    }

    @Nonnull
    public <T> List<T> batchGet(Class<T> klass, List<?> ids, @Nullable Callable<List<T>> callbackOnMiss) {
        List<T> cachedInstances;
        if (!InvokeCache.isThreadLocalInit()) {
            try {
                if (null != callbackOnMiss) {
                    return callbackOnMiss.call();
                }
                return Collections.emptyList();
            }
            catch (Exception ex) {
                this.handleCallException(klass, ids, ex);
            }
        }
        if ((cachedInstances = this.batchGet0(klass, ids)).size() > ids.size()) {
            throw new IllegalStateException(InvokeCache.format("incorrect cache size. expected %s, but got %s", ids.size(), cachedInstances.size()));
        }
        if (cachedInstances.size() == ids.size()) {
            return cachedInstances;
        }
        if (callbackOnMiss != null) {
            try {
                List<T> ret = callbackOnMiss.call();
                this.batchPut(klass, ids, ret);
                return ret;
            }
            catch (Exception ex) {
                this.handleCallException(klass, ids, ex);
            }
        }
        return Collections.emptyList();
    }

    private void handleCallException(Class<?> klass, List<?> ids, Exception ex) {
        Message errorMessage;
        if (ex instanceof LatticeRuntimeException && null != (errorMessage = ((LatticeRuntimeException)ex).getErrorMessage())) {
            throw new LatticeRuntimeException(Message.of(errorMessage.getCode(), errorMessage.getText()));
        }
        throw new LatticeRuntimeException("LATTICE-CORE-001", klass.getName(), ids.stream().map(Object::toString).collect(Collectors.joining(",")), ex.getMessage());
    }

    @Nonnull
    <T> List<T> batchGet0(@Nonnull Class<T> klass, @Nonnull List<?> ids) {
        if (!InvokeCache.isThreadLocalInit()) {
            return Collections.emptyList();
        }
        Iterator<?> idsItr = ids.iterator();
        ArrayList ret = Lists.newArrayListWithCapacity((int)ids.size());
        while (idsItr.hasNext()) {
            Object id = idsItr.next();
            Object cachedInstance = this.get0(klass, id, null);
            if (cachedInstance == NULL) {
                ret.add(null);
                continue;
            }
            if (cachedInstance != null) {
                ret.add(cachedInstance);
                continue;
            }
            return Collections.emptyList();
        }
        return ret;
    }

    @Nonnull
    private Map<Object, Object> getIdToInstanceCache(@Nonnull Class<?> klass) {
        return this.cache.computeIfAbsent(klass, k -> new HashMap());
    }

    public void clear() {
        ((InvokeCache)INSTANCE.get()).getClass();
        INSTANCE.remove();
    }

    public void clear(@Nonnull Class<?> klass) {
        Map<Object, Object> cacheOfClass = this.cache.get(klass);
        if (cacheOfClass != null) {
            this.cache.remove(klass);
        }
    }

    public static String format(String template, Object ... args) {
        int placeholderStart;
        StringBuilder builder = new StringBuilder(template.length() + 16 * args.length);
        int templateStart = 0;
        int i = 0;
        while (i < args.length && (placeholderStart = template.indexOf("%s", templateStart)) != -1) {
            builder.append(template, templateStart, placeholderStart);
            builder.append(args[i++]);
            templateStart = placeholderStart + 2;
        }
        builder.append(template.substring(templateStart));
        if (i < args.length) {
            builder.append(" [");
            builder.append(args[i++]);
            while (i < args.length) {
                builder.append(", ");
                builder.append(args[i++]);
            }
            builder.append("]");
        }
        return builder.toString();
    }

    private static class Null {
        private Null() {
        }
    }
}

