/*
 * Decompiled with CFR 0.152.
 */
package org.hiforce.lattice.exception;

import org.apache.commons.lang3.StringUtils;
import org.hiforce.lattice.exception.ILatticeException;
import org.hiforce.lattice.message.Message;
import org.jetbrains.annotations.PropertyKey;

public class LatticeRuntimeException
extends RuntimeException
implements ILatticeException {
    private static final long serialVersionUID = -813481135380936090L;
    private Message realMessage = null;

    public LatticeRuntimeException(Throwable th) {
        super(th);
        Message errorMessage;
        if (th instanceof ILatticeException && null != (errorMessage = ((ILatticeException)((Object)th)).getErrorMessage())) {
            this.realMessage = Message.of(errorMessage.getCode(), errorMessage.getText());
        }
        if (null == this.realMessage) {
            this.realMessage = Message.defaultError();
        }
    }

    public LatticeRuntimeException(@PropertyKey(resourceBundle="i18n.infos") @PropertyKey(resourceBundle="i18n.infos") String key, Object ... params) {
        this.realMessage = Message.code(key, params);
    }

    public LatticeRuntimeException(Message message) {
        this.realMessage = message;
    }

    public LatticeRuntimeException(Throwable th, Message message) {
        super(th);
        this.realMessage = message;
    }

    @Override
    public Message getErrorMessage() {
        if (null != this.realMessage) {
            return this.realMessage;
        }
        return Message.defaultError();
    }

    @Override
    public String getMessage() {
        String error;
        Message message = this.getErrorMessage();
        if (null != message && null != (error = message.toString())) {
            return error;
        }
        error = super.getMessage();
        if (StringUtils.isNotEmpty((CharSequence)error)) {
            return error;
        }
        return Message.defaultError().toString();
    }
}

