/*
 * Decompiled with CFR 0.152.
 */
package org.hiforce.lattice.extension;

import java.util.List;
import javax.annotation.Nonnull;
import org.hiforce.lattice.extension.ExtensionRunnerType;
import org.hiforce.lattice.model.ability.IAbility;
import org.hiforce.lattice.model.ability.IBusinessExt;
import org.hiforce.lattice.model.ability.execute.ExtensionCallback;
import org.hiforce.lattice.model.business.IBizObject;

public abstract class ExtensionRunner<R> {
    private String extensionCode;
    private IBusinessExt model;

    public abstract void setAbility(IAbility var1);

    public ExtensionRunner(String extensionCode) {
        this.extensionCode = extensionCode;
    }

    public ExtensionRunner(String extensionCode, IBusinessExt model) {
        this.model = model;
        this.extensionCode = extensionCode;
    }

    public abstract R runFirstMatched(IBizObject var1, ExtensionCallback<IBusinessExt, R> var2, RunnerExecuteResult var3);

    @Nonnull
    public abstract List<R> runAllMatched(IBizObject var1, ExtensionCallback<IBusinessExt, R> var2, RunnerExecuteResult var3);

    public abstract ExtensionRunnerType getType();

    public String getExtensionCode() {
        return this.extensionCode;
    }

    public void setExtensionCode(String extensionCode) {
        this.extensionCode = extensionCode;
    }

    public IBusinessExt getModel() {
        return this.model;
    }

    public void setModel(IBusinessExt model) {
        this.model = model;
    }

    public static final class CollectionRunnerExecuteResult
    extends RunnerExecuteResult {
        private List results;

        public final List getResults() {
            return this.results;
        }

        public final void setResults(List results) {
            this.results = results;
        }
    }

    public static class RunnerExecuteResult {
        private boolean execute;
        private ExtensionRunnerType runnerType;

        public boolean isExecute() {
            return this.execute;
        }

        public void setExecute(boolean execute) {
            this.execute = execute;
        }

        public ExtensionRunnerType getRunnerType() {
            return this.runnerType;
        }

        public void setRunnerType(ExtensionRunnerType runnerType) {
            this.runnerType = runnerType;
        }
    }
}

