/*
 * Decompiled with CFR 0.152.
 */
package org.hiforce.lattice.message;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.hiforce.lattice.message.MessageCode;
import org.hiforce.lattice.message.MessageHelper;
import org.jetbrains.annotations.PropertyKey;

public class Message
implements Serializable {
    public static final Map<String, Message> cachedMessages = new ConcurrentHashMap<String, Message>(500);
    private static final long serialVersionUID = 19894637804946296L;
    private String code = null;
    private String readableCode = null;
    private String text = null;
    private String displayText = null;
    private String group;
    private Map<String, Object> contents = new HashMap<String, Object>();

    private Message(String code, String message, String displayMessage, String readableCode) {
        this.code = code;
        this.text = message;
        this.displayText = displayMessage;
        this.readableCode = readableCode;
    }

    public static Message defaultError() {
        return MessageHelper.defaultOne();
    }

    public static Message of(String errorCode, String message) {
        return Message.of(errorCode, message, message);
    }

    public static Message code(@PropertyKey(resourceBundle="i18n.infos") @PropertyKey(resourceBundle="i18n.infos") String key, Object ... params) {
        if (params != null && params.length > 0) {
            return MessageCode.toErrorMessage(key, params);
        }
        Message message = cachedMessages.get(key);
        if (message == null) {
            message = MessageCode.toErrorMessage(key, params);
            cachedMessages.put(key, message);
        }
        return Message.of(message.getCode(), message.getText(), message.getDisplayText(), message.getReadableCode());
    }

    public static Message of(String code, String message, String displayMessage) {
        return Message.of(code, message, displayMessage, "");
    }

    public static Message of(String code, String text, String displayText, String readableCode) {
        Message m = new Message();
        m.code = code;
        m.text = text;
        m.displayText = displayText;
        m.readableCode = readableCode;
        return m;
    }

    public Message addErrorContents(Map<String, Object> errorContents) {
        if (MapUtils.isNotEmpty(errorContents)) {
            this.contents.putAll(errorContents);
        }
        return this;
    }

    public String toString() {
        String message = "ErrorMessage{c='" + this.code + '\'' + ", rC='" + this.readableCode + '\'' + ", m='" + this.text + '\'';
        String content = this.contentToString();
        if (StringUtils.isNotBlank((CharSequence)content)) {
            message = message + " ct=' " + content + '\'';
        }
        return message + "}";
    }

    public String getFullText() {
        return "Message{code='" + this.code + '\'' + ", text='" + this.text + '\'' + ", displayText='" + this.displayText + '\'' + ", readableCode='" + this.readableCode + '\'' + ", group='" + this.group + '\'' + ", contents=" + this.contents + '}';
    }

    public String contentToString() {
        if (MapUtils.isEmpty(this.contents)) {
            return "";
        }
        StringBuilder buffer = new StringBuilder(128);
        for (Map.Entry<String, Object> p : this.contents.entrySet()) {
            if (buffer.length() > 0) {
                buffer.append(", ");
            }
            buffer.append(p.getKey()).append(" => ").append(p.getValue());
        }
        return "{" + buffer.toString() + "}";
    }

    public static void clean() {
        cachedMessages.clear();
    }

    public Message() {
    }

    public String getCode() {
        return this.code;
    }

    public String getReadableCode() {
        return this.readableCode;
    }

    public String getText() {
        return this.text;
    }

    public String getDisplayText() {
        return this.displayText;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public Map<String, Object> getContents() {
        return this.contents;
    }

    public void setContents(Map<String, Object> contents) {
        this.contents = contents;
    }
}

