/*
 * Decompiled with CFR 0.152.
 */
package org.hiforce.lattice.message;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.hiforce.lattice.exception.LatticeRuntimeException;
import org.hiforce.lattice.message.Message;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.PropertyKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageCode {
    private static final Logger log = LoggerFactory.getLogger(MessageCode.class);
    public static final String DEFAULT_DISPLAY_ERROR_MESSAGE = "\u5bf9\u4e0d\u8d77\uff0c\u7cfb\u7edf\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u5019\u518d\u8bd5";
    @NotNull
    public static final String BUNDLE = "i18n.infos";
    private static final String DEFAULT_LOG_ERROR_MESSAGE = "ERROR MESSAGE IS MISSING";
    private static final String defaultDisplayFilePath = "i18n/infos_zh_CN.properties";
    private static final String internalErrorMessageFilePath = "i18n/infos_en_AA.properties";
    private static final String readableErrorCodeFilePath = "i18n/infos_en_XA.properties";
    private static final Map<String, Object> allDisplayErrorCodes = new ConcurrentHashMap<String, Object>();
    private static Map<Object, Object> displayErrorCodes = new ConcurrentHashMap<Object, Object>();
    private static Map<Object, Object> internalErrorMessage = new ConcurrentHashMap<Object, Object>();
    private static Map<Object, Object> readableErrorCode = new ConcurrentHashMap<Object, Object>();
    private static final Map<Object, Object> nonStandardReadableErrorCode = new ConcurrentHashMap<Object, Object>();
    private static final Map<String, String> cachedLogMessage = new ConcurrentHashMap<String, String>();

    public static void init() {
        internalErrorMessage = MessageCode.extractErrorCodes(internalErrorMessageFilePath);
        readableErrorCode = MessageCode.extractErrorCodes(readableErrorCodeFilePath);
        displayErrorCodes = MessageCode.extractErrorCodes(defaultDisplayFilePath);
        MessageCode.processReadableErrorCode();
    }

    private static void processReadableErrorCode() {
        String raw;
        nonStandardReadableErrorCode.clear();
        for (Map.Entry<Object, Object> entry : readableErrorCode.entrySet()) {
            raw = entry.getValue().toString();
            try {
                String encoded = URLEncoder.encode(raw, "UTF-8");
                if (raw.equals(encoded)) continue;
                nonStandardReadableErrorCode.put(entry.getKey(), raw);
            }
            catch (UnsupportedEncodingException e) {
                throw new LatticeRuntimeException(e);
            }
        }
        for (Map.Entry<Object, Object> entry : nonStandardReadableErrorCode.entrySet()) {
            raw = entry.getValue().toString();
            try {
                readableErrorCode.put(entry.getKey(), URLEncoder.encode(raw, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new LatticeRuntimeException(e);
            }
        }
    }

    private static String logMessageWithoutCode(@PropertyKey(resourceBundle="i18n.infos") @NotNull @PropertyKey(resourceBundle="i18n.infos") @NotNull String key, Object ... params) {
        String result;
        boolean canNotCache;
        boolean bl = canNotCache = params != null && params.length > 0;
        if (!canNotCache && (result = cachedLogMessage.get(key)) != null) {
            return result;
        }
        String logMessage = "log message cannot be retrieved properly";
        try {
            logMessage = MessageCode.searchKeyInAllResourceFile(internalErrorMessage, key, DEFAULT_LOG_ERROR_MESSAGE, params);
        }
        catch (Exception e) {
            log.error(logMessage, (Throwable)e);
        }
        String result2 = logMessage;
        if (!canNotCache) {
            cachedLogMessage.put(key, result2);
        }
        return result2;
    }

    public static String displayMessage(@PropertyKey(resourceBundle="i18n.infos") @PropertyKey(resourceBundle="i18n.infos") String key, Object ... params) {
        return MessageCode.searchKeyInAllResourceFile(displayErrorCodes, key, DEFAULT_DISPLAY_ERROR_MESSAGE, params);
    }

    private static String searchKeyInAllResourceFile(Map<Object, Object> props, String key, String defaultValue, Object ... params) {
        if (!props.containsKey(key)) {
            return defaultValue;
        }
        Object obj = props.get(key);
        String message = MessageCode.buildMessage(obj, params);
        return StringUtils.isNotBlank((CharSequence)message) ? message : defaultValue;
    }

    private static String buildMessage(Object obj, Object[] params) {
        String message = String.valueOf(obj);
        if (params != null && params.length > 0 && message != null && message.indexOf(123) >= 0) {
            message = MessageFormat.format(message, params);
        }
        if (params != null && params.length > 0 && message != null && message.contains("{0}")) {
            message = MessageFormat.format(message, params);
        }
        return message;
    }

    private static Map<Object, Object> extractErrorCodes(String resourceFilePath) {
        return MessageCode.extractErrorCodes(resourceFilePath, false, null);
    }

    private static Map<Object, Object> extractErrorCodes(String resourceFilePath, boolean replaceEnglishWords, String replaceText) {
        return new HashMap<Object, Object>(MessageCode.extractErrorCodes(Thread.currentThread().getContextClassLoader(), resourceFilePath, replaceEnglishWords, replaceText));
    }

    public static Map<Object, Object> extractErrorCodes(ClassLoader classLoader, String resourceFilePath, boolean replaceEnglishWords, String replaceText) {
        HashMap<Object, Object> props = new HashMap<Object, Object>();
        try {
            Enumeration<URL> resources = classLoader.getResources(resourceFilePath);
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                InputStream in = url.openStream();
                Properties prop = new Properties();
                prop.load(new InputStreamReader(in, "UTF-8"));
                if (replaceEnglishWords) {
                    for (Map.Entry<Object, Object> entry : prop.entrySet()) {
                        if (MessageCode.hasChineseCharacter(String.valueOf(entry.getValue()))) continue;
                        entry.setValue(replaceText);
                    }
                }
                props.putAll(prop);
            }
        }
        catch (IOException e) {
            log.error("The target resource [{}] is not available ... ", (Object)resourceFilePath);
            return Collections.emptyMap();
        }
        return props;
    }

    public static final boolean hasChineseCharacter(String chineseStr) {
        char[] charArray = chineseStr.toCharArray();
        for (int i = 0; i < charArray.length; ++i) {
            if (charArray[i] < '\u4e00' || charArray[i] > '\u9fbb') continue;
            return true;
        }
        return false;
    }

    private static Map<Object, Object> extractContextErrorCodes(String resourceFilePath, boolean replaceEnglishWords, String replaceText) {
        return new HashMap<Object, Object>(MessageCode.extractErrorCodes(Thread.currentThread().getContextClassLoader(), resourceFilePath, replaceEnglishWords, replaceText));
    }

    static Message toErrorMessage(@PropertyKey(resourceBundle="i18n.infos") @PropertyKey(resourceBundle="i18n.infos") String key, Object ... params) {
        String logMessage = MessageCode.logMessageWithoutCode(key, params);
        String displayMessage = MessageCode.displayMessage(key, params);
        String readableCode = MessageCode.searchKeyInAllResourceFile(readableErrorCode, key, key, new Object[0]);
        return Message.of(key, logMessage, displayMessage, readableCode);
    }

    public static void setI18n(String i18nCode) {
        if (allDisplayErrorCodes.containsKey(i18nCode)) {
            displayErrorCodes = (Map)allDisplayErrorCodes.get(i18nCode);
        } else {
            displayErrorCodes = MessageCode.extractContextErrorCodes("i18n/infos_" + i18nCode + ".properties", false, DEFAULT_DISPLAY_ERROR_MESSAGE);
            allDisplayErrorCodes.put(i18nCode, displayErrorCodes);
        }
    }

    static {
        MessageCode.init();
    }
}

