/*
 * Decompiled with CFR 0.152.
 */
package org.hiforce.lattice.model.business;

import java.io.Serializable;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.hiforce.lattice.cache.invoke.InvokeCache;

public abstract class BizContext
implements Serializable {
    private static final long serialVersionUID = 4886210062129912701L;
    private int hashCode;

    public abstract Serializable getBizId();

    public abstract String getBizCode();

    public abstract String getScenario();

    public String getBizInfo() {
        return String.format("[BizCode: %s, BizId: %s]", this.getBizCode(), this.getBizId());
    }

    public <T> void addExtObject(Class<? super T> klass, @Nullable T instance) {
        InvokeCache.instance().put(klass, this.getBizId(), instance);
    }

    public <T> T getExtObject(Class<? extends T> klass) {
        return InvokeCache.instance().get(klass, this.getBizId());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BizContext)) {
            return false;
        }
        BizContext that = (BizContext)o;
        if (!StringUtils.equals((CharSequence)this.getBizCode(), (CharSequence)that.getBizCode())) {
            return false;
        }
        return null != this.getBizId() && this.getBizId().equals(that.getBizId());
    }

    public int hashCode() {
        int hashCode = this.hashCode;
        if (hashCode > 0) {
            return hashCode;
        }
        int result = 31;
        if (StringUtils.isNotEmpty((CharSequence)this.getBizCode())) {
            result *= this.getBizCode().hashCode();
        }
        if (null != this.getBizId()) {
            result = 31 * result + this.getBizId().hashCode();
        }
        this.hashCode = result;
        return result;
    }
}

