/*
 * Decompiled with CFR 0.152.
 */
package org.hiforce.lattice.model.business;

import org.apache.commons.lang3.StringUtils;
import org.hiforce.lattice.cache.ITemplateCache;
import org.hiforce.lattice.cache.LatticeCacheFactory;
import org.hiforce.lattice.model.business.ITemplate;

public abstract class Template
implements ITemplate {
    private Long uniqueId;
    private String code;
    private Long internalId;
    private Boolean isPatternCode;

    @Override
    public Long getInternalId() {
        if (null == this.internalId) {
            ITemplateCache templateCache = LatticeCacheFactory.getInstance().getRuntimeCache().getTemplateIndex();
            this.internalId = (Long)templateCache.getSecondKeyViaFirstKey(this.getCode());
        }
        return this.internalId;
    }

    @Override
    public boolean isPatternTemplateCode() {
        if (null != this.isPatternCode) {
            return this.isPatternCode;
        }
        this.isPatternCode = StringUtils.contains((CharSequence)this.getCode(), (CharSequence)"*");
        return this.isPatternCode;
    }

    public void setCode(String code) {
        if (StringUtils.isNotEmpty((CharSequence)code)) {
            this.code = code.intern();
        }
    }

    public Long getUniqueId() {
        return this.uniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.uniqueId = uniqueId;
    }

    @Override
    public String getCode() {
        return this.code;
    }

    public void setInternalId(Long internalId) {
        this.internalId = internalId;
    }
}

