/*
 * Decompiled with CFR 0.152.
 */
package org.hiforce.lattice.model.config;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.hiforce.lattice.model.config.ExtPriority;
import org.hiforce.lattice.model.config.ExtPriorityConfig;
import org.hiforce.lattice.model.config.ProductConfig;

public class BusinessConfig
implements Serializable {
    private static final long serialVersionUID = 2955186375325583813L;
    private String bizCode;
    private int priority = 1000;
    private boolean autoBuild;
    private final Set<ProductConfig> products = Sets.newHashSet();
    private List<ExtPriorityConfig> extensions = Lists.newArrayList();

    public BusinessConfig(String bizCode, int priority, Set<ProductConfig> products, List<ExtPriorityConfig> extensions) {
        this.bizCode = bizCode;
        this.priority = priority;
        this.products.addAll(products);
        this.extensions.addAll(extensions);
    }

    public boolean productInstalled(String productCode) {
        return this.products.stream().filter(p -> StringUtils.equals((CharSequence)p.getCode(), (CharSequence)productCode)).findFirst().isPresent();
    }

    public boolean notContainExtCode(String extCode) {
        return !this.extensions.stream().filter(p -> StringUtils.equals((CharSequence)extCode, (CharSequence)p.getExtCode())).findFirst().isPresent();
    }

    public ProductConfig getProductConfig(String productCode) {
        return this.products.stream().filter(p -> StringUtils.equals((CharSequence)productCode, (CharSequence)p.getCode())).findFirst().orElse(null);
    }

    public ExtPriorityConfig getExtPriorityConfigByExtCode(String extCode) {
        return this.extensions.stream().filter(p -> StringUtils.equals((CharSequence)extCode, (CharSequence)p.getExtCode())).findFirst().orElse(null);
    }

    public List<ExtPriority> getExtPriorityByCode(String extCode, boolean onlyHorizontal) {
        ExtPriorityConfig priorityConfig = this.extensions.stream().filter(p -> StringUtils.equals((CharSequence)extCode, (CharSequence)p.getExtCode())).findFirst().orElse(null);
        if (null == priorityConfig) {
            return null;
        }
        List<ExtPriority> priorities = priorityConfig.getPriorities().stream().filter(p -> onlyHorizontal ? p.getType().isHorizontal() : true).collect(Collectors.toList());
        return priorities;
    }

    public BusinessConfig() {
    }

    public String getBizCode() {
        return this.bizCode;
    }

    public void setBizCode(String bizCode) {
        this.bizCode = bizCode;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public boolean isAutoBuild() {
        return this.autoBuild;
    }

    public void setAutoBuild(boolean autoBuild) {
        this.autoBuild = autoBuild;
    }

    public Set<ProductConfig> getProducts() {
        return this.products;
    }

    public List<ExtPriorityConfig> getExtensions() {
        return this.extensions;
    }
}

