/*
 * Decompiled with CFR 0.152.
 */
package org.hiforce.lattice.model.config.builder;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.hiforce.lattice.model.config.BusinessConfig;
import org.hiforce.lattice.model.config.ExtPriorityConfig;
import org.hiforce.lattice.model.config.ProductConfig;

public class BusinessConfigBuilder {
    private String bizCode;
    private int priority = 1000;
    private final Set<ProductConfig> products = Sets.newHashSet();
    private final List<ExtPriorityConfig> extensions = Lists.newArrayList();

    private BusinessConfigBuilder() {
    }

    public static BusinessConfigBuilder builder() {
        return new BusinessConfigBuilder();
    }

    public BusinessConfigBuilder bizCode(String bizCode) {
        this.bizCode = bizCode;
        return this;
    }

    public BusinessConfigBuilder priority(int priority) {
        this.priority = priority;
        return this;
    }

    public BusinessConfigBuilder install(String ... productCodes) {
        if (null == productCodes) {
            return this;
        }
        this.products.addAll(Arrays.stream(productCodes).map(ProductConfig::of).collect(Collectors.toList()));
        return this;
    }

    public BusinessConfigBuilder install(ProductConfig ... products) {
        if (null == products) {
            return this;
        }
        this.products.addAll(Arrays.asList(products));
        return this;
    }

    public BusinessConfigBuilder install(List<ProductConfig> products) {
        if (null == products) {
            return this;
        }
        this.products.addAll(products);
        return this;
    }

    public BusinessConfigBuilder extension(ExtPriorityConfig ... extConfigs) {
        if (null == extConfigs) {
            return this;
        }
        this.extensions.addAll(Arrays.asList(extConfigs));
        return this;
    }

    public BusinessConfigBuilder extension(List<ExtPriorityConfig> extConfigs) {
        if (null == extConfigs) {
            return this;
        }
        this.extensions.addAll(extConfigs);
        return this;
    }

    public BusinessConfig build() {
        BusinessConfig config = new BusinessConfig();
        config.setPriority(this.priority);
        config.setBizCode(this.bizCode);
        config.getProducts().addAll(this.products);
        config.getExtensions().addAll(this.extensions);
        return config;
    }

    public String getBizCode() {
        return this.bizCode;
    }

    public void setBizCode(String bizCode) {
        this.bizCode = bizCode;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public Set<ProductConfig> getProducts() {
        return this.products;
    }

    public List<ExtPriorityConfig> getExtensions() {
        return this.extensions;
    }
}

