/*
 * Decompiled with CFR 0.152.
 */
package org.hiforce.lattice.model.config.builder;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.collections4.CollectionUtils;
import org.hiforce.lattice.model.business.TemplateType;
import org.hiforce.lattice.model.config.ExtPriority;
import org.hiforce.lattice.model.config.ExtPriorityConfig;

public class PriorityConfigBuilder {
    private String extCode;
    private List<ExtPriority> priorities;

    private PriorityConfigBuilder() {
    }

    public static PriorityConfigBuilder builder() {
        return new PriorityConfigBuilder();
    }

    public ExtPriorityConfig build() {
        ExtPriorityConfig config = new ExtPriorityConfig();
        config.setExtCode(this.extCode);
        config.getPriorities().addAll(this.priorities);
        return config;
    }

    public PriorityConfigBuilder extCode(String extCode) {
        this.extCode = extCode;
        return this;
    }

    public PriorityConfigBuilder priority(@Nonnull String templateCode, @Nonnull TemplateType type) {
        if (this.priorities == null) {
            this.priorities = Lists.newArrayList();
        }
        this.priorities.add(ExtPriority.of(templateCode, type));
        return this;
    }

    public PriorityConfigBuilder priority(ExtPriority priority) {
        if (null == priority) {
            return this;
        }
        if (this.priorities == null) {
            this.priorities = Lists.newArrayList();
        }
        this.priorities.add(priority);
        return this;
    }

    public PriorityConfigBuilder priorities(List<ExtPriority> priorities) {
        if (CollectionUtils.isEmpty(priorities)) {
            this.priorities = Lists.newArrayList();
            return this;
        }
        this.priorities = priorities;
        return this;
    }

    public String getExtCode() {
        return this.extCode;
    }
}

