/*
 * Decompiled with CFR 0.152.
 */
package org.hiforce.lattice.model.register;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.hiforce.lattice.model.register.AbilityInstSpec;
import org.hiforce.lattice.model.register.BaseSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbilitySpec
extends BaseSpec {
    private static final Logger log = LoggerFactory.getLogger(AbilitySpec.class);
    private String parentCode;
    private String parentType;
    private Class<?> abilityClass;
    private Map<String, AbilityInstSpec> abilityInstSpecMap = Maps.newConcurrentMap();
    private final Set<AbilityInstSpec> abilityInstances = Sets.newConcurrentHashSet();

    public static AbilitySpec of(String code, String name, String desc) {
        AbilitySpec abilitySpec = new AbilitySpec();
        abilitySpec.setCode(code);
        abilitySpec.setName(name);
        abilitySpec.setDescription(desc);
        return abilitySpec;
    }

    public void addAbilityInstance(AbilityInstSpec abilityInstSpec) {
        if (null == abilityInstSpec) {
            return;
        }
        if (this.abilityInstSpecMap.containsKey(abilityInstSpec.getCode())) {
            log.debug("Duplicated ability instance registered\uff0ccode: [{}], name: [{}]", (Object)abilityInstSpec.getCode(), (Object)abilityInstSpec.getName());
            return;
        }
        abilityInstSpec.setAbilityCode(this.getCode());
        this.abilityInstSpecMap.put(abilityInstSpec.getCode(), abilityInstSpec);
    }

    public void addAbilityInstance(List<AbilityInstSpec> instanceSpecs) {
        if (CollectionUtils.isEmpty(instanceSpecs)) {
            return;
        }
        for (AbilityInstSpec abilityInstanceSpec : instanceSpecs) {
            if (abilityInstanceSpec.inList(this.abilityInstances)) {
                log.debug("[Lattice]AbilityInstance\u91cd\u590d\u6ce8\u518c\uff0c[{}-{}]", (Object)abilityInstanceSpec.getName(), (Object)abilityInstanceSpec.getCode());
                continue;
            }
            abilityInstanceSpec.setAbilityCode(this.getCode());
            this.abilityInstances.add(abilityInstanceSpec);
        }
        this.rebuildAbilityInstanceSpecMap();
    }

    private Map<String, AbilityInstSpec> rebuildAbilityInstanceSpecMap() {
        this.abilityInstSpecMap = Maps.newConcurrentMap();
        if (CollectionUtils.isEmpty(this.abilityInstances)) {
            return this.abilityInstSpecMap;
        }
        for (AbilityInstSpec abilityInstance : this.abilityInstances) {
            if (StringUtils.isBlank((CharSequence)abilityInstance.getInstanceClass())) continue;
            this.abilityInstSpecMap.put(abilityInstance.getInstanceClass(), abilityInstance);
        }
        return this.abilityInstSpecMap;
    }

    public boolean equals(Object obj) {
        if (null == obj) {
            return false;
        }
        if (!(obj instanceof AbilitySpec)) {
            return false;
        }
        AbilitySpec target = (AbilitySpec)obj;
        return StringUtils.equals((CharSequence)target.getCode(), (CharSequence)this.getCode());
    }

    public int hashCode() {
        if (StringUtils.isEmpty((CharSequence)this.getCode())) {
            return super.hashCode();
        }
        return this.getCode().hashCode();
    }

    public String toString() {
        return "Ability{code='" + this.getCode() + '\'' + "name='" + this.getName() + '\'' + '}';
    }

    public String getParentCode() {
        return this.parentCode;
    }

    public void setParentCode(String parentCode) {
        this.parentCode = parentCode;
    }

    public String getParentType() {
        return this.parentType;
    }

    public void setParentType(String parentType) {
        this.parentType = parentType;
    }

    public Class<?> getAbilityClass() {
        return this.abilityClass;
    }

    public void setAbilityClass(Class<?> abilityClass) {
        this.abilityClass = abilityClass;
    }

    public Map<String, AbilityInstSpec> getAbilityInstSpecMap() {
        return this.abilityInstSpecMap;
    }

    public Set<AbilityInstSpec> getAbilityInstances() {
        return this.abilityInstances;
    }
}

