/*
 * Decompiled with CFR 0.152.
 */
package org.hiforce.lattice.model.register;

import org.hiforce.lattice.exception.LatticeRuntimeException;
import org.hiforce.lattice.model.business.BusinessTemplate;
import org.hiforce.lattice.model.business.TemplateType;
import org.hiforce.lattice.model.register.TemplateSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BusinessSpec
extends TemplateSpec<BusinessTemplate> {
    private static final Logger log = LoggerFactory.getLogger(BusinessSpec.class);
    private Class<?> businessClass;

    public BusinessSpec() {
        this.setPriority(1000);
        this.setType(TemplateType.BUSINESS);
    }

    @Override
    public BusinessTemplate newInstance() {
        if (null == this.businessClass) {
            return null;
        }
        try {
            BusinessTemplate template = (BusinessTemplate)this.businessClass.newInstance();
            template.setCode(this.getCode());
            template.setInternalId(this.getInternalId());
            template.setPriority(this.getPriority());
            return template;
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            throw new LatticeRuntimeException("LATTICE-CORE-004", ex.getMessage());
        }
    }

    public Class<?> getBusinessClass() {
        return this.businessClass;
    }

    public void setBusinessClass(Class<?> businessClass) {
        this.businessClass = businessClass;
    }
}

