/*
 * Decompiled with CFR 0.152.
 */
package org.hiforce.lattice.model.register;

import java.lang.reflect.Method;
import org.apache.commons.lang3.StringUtils;
import org.hiforce.lattice.annotation.model.ProtocolType;
import org.hiforce.lattice.annotation.model.ReduceType;
import org.hiforce.lattice.model.register.BaseSpec;
import org.hiforce.lattice.sequence.SequenceGenerator;

public class ExtensionSpec
extends BaseSpec {
    private final long internalId = SequenceGenerator.next(ExtensionSpec.class.getName());
    private int priority;
    private String abilityCode;
    private final Method invokeMethod;
    private ReduceType reduceType = ReduceType.UNKNOWN;
    private ProtocolType protocolType = ProtocolType.LOCAL;
    private String groupCode;
    private String groupName;
    private Class<?> itfClass;

    public ExtensionSpec(Method invokeMethod) {
        this.invokeMethod = invokeMethod;
    }

    public static ExtensionSpec of(Method invokeMethod, String abilityCode, String extensionCode, String extensionName, String extensionDesc) {
        ExtensionSpec extensionSpec = new ExtensionSpec(invokeMethod);
        extensionSpec.abilityCode = abilityCode;
        extensionSpec.setCode(extensionCode);
        extensionSpec.setName(StringUtils.isNotEmpty((CharSequence)extensionCode) ? invokeMethod.getName() : extensionName);
        extensionSpec.setDescription(extensionDesc);
        return extensionSpec;
    }

    public boolean equals(Object obj) {
        if (null == obj) {
            return false;
        }
        if (!(obj instanceof ExtensionSpec)) {
            return false;
        }
        ExtensionSpec target = (ExtensionSpec)obj;
        return StringUtils.equals((CharSequence)target.getCode(), (CharSequence)this.getCode());
    }

    public int hashCode() {
        if (StringUtils.isNotEmpty((CharSequence)this.getCode())) {
            return this.getCode().hashCode();
        }
        return super.hashCode();
    }

    public String toString() {
        return "ExtensionPointSpec{name='" + this.getName() + '\'' + ", code='" + this.getCode() + '\'' + ", ability='" + this.abilityCode + '\'' + ", method=" + this.invokeMethod + '}';
    }

    public long getInternalId() {
        return this.internalId;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public String getAbilityCode() {
        return this.abilityCode;
    }

    public Method getInvokeMethod() {
        return this.invokeMethod;
    }

    public ReduceType getReduceType() {
        return this.reduceType;
    }

    public void setReduceType(ReduceType reduceType) {
        this.reduceType = reduceType;
    }

    public ProtocolType getProtocolType() {
        return this.protocolType;
    }

    public void setProtocolType(ProtocolType protocolType) {
        this.protocolType = protocolType;
    }

    public String getGroupCode() {
        return this.groupCode;
    }

    public void setGroupCode(String groupCode) {
        this.groupCode = groupCode;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public Class<?> getItfClass() {
        return this.itfClass;
    }

    public void setItfClass(Class<?> itfClass) {
        this.itfClass = itfClass;
    }
}

