/*
 * Decompiled with CFR 0.152.
 */
package org.hiforce.lattice.model.register;

import org.hiforce.lattice.exception.LatticeRuntimeException;
import org.hiforce.lattice.model.business.ProductTemplate;
import org.hiforce.lattice.model.business.TemplateType;
import org.hiforce.lattice.model.register.TemplateSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProductSpec
extends TemplateSpec<ProductTemplate> {
    private static final Logger log = LoggerFactory.getLogger(ProductSpec.class);
    private Class<?> productClass;

    public ProductSpec() {
        this.setPriority(500);
        this.setType(TemplateType.PRODUCT);
    }

    @Override
    public ProductTemplate newInstance() {
        if (null == this.productClass) {
            return null;
        }
        try {
            return (ProductTemplate)this.productClass.newInstance();
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            throw new LatticeRuntimeException("LATTICE-CORE-002", ex.getMessage());
        }
    }

    public Class<?> getProductClass() {
        return this.productClass;
    }

    public void setProductClass(Class<?> productClass) {
        this.productClass = productClass;
    }
}

