/*
 * Decompiled with CFR 0.152.
 */
package org.hiforce.lattice.model.register;

import com.google.common.collect.Lists;
import java.util.List;
import org.hiforce.lattice.cache.ITemplateCache;
import org.hiforce.lattice.cache.LatticeCacheFactory;
import org.hiforce.lattice.model.business.ITemplate;
import org.hiforce.lattice.model.business.TemplateType;
import org.hiforce.lattice.model.register.BaseSpec;
import org.hiforce.lattice.model.register.RealizationSpec;

public abstract class TemplateSpec<T extends ITemplate>
extends BaseSpec {
    private int priority;
    private TemplateType type;
    private final List<RealizationSpec> realizations = Lists.newArrayList();
    private boolean remote;
    private Long internalId;

    public Long getInternalId() {
        if (null == this.internalId) {
            ITemplateCache templateCache = LatticeCacheFactory.getInstance().getRuntimeCache().getTemplateIndex();
            this.internalId = (Long)templateCache.getSecondKeyViaFirstKey(this.getCode());
        }
        return this.internalId;
    }

    public abstract T newInstance();

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public TemplateType getType() {
        return this.type;
    }

    public void setType(TemplateType type) {
        this.type = type;
    }

    public List<RealizationSpec> getRealizations() {
        return this.realizations;
    }

    public boolean isRemote() {
        return this.remote;
    }

    public void setRemote(boolean remote) {
        this.remote = remote;
    }

    public void setInternalId(Long internalId) {
        this.internalId = internalId;
    }
}

