/*
 * Decompiled with CFR 0.152.
 */
package org.hiforce.lattice.model.register;

import com.google.common.collect.Sets;
import java.util.Set;
import org.hiforce.lattice.exception.LatticeRuntimeException;
import org.hiforce.lattice.model.ability.IBusinessExt;
import org.hiforce.lattice.model.business.TemplateType;
import org.hiforce.lattice.model.business.UseCaseTemplate;
import org.hiforce.lattice.model.register.ExtensionSpec;
import org.hiforce.lattice.model.register.TemplateSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UseCaseSpec
extends TemplateSpec<UseCaseTemplate> {
    private static final Logger log = LoggerFactory.getLogger(UseCaseSpec.class);
    private Class<?> useCaseClass;
    private Class<? extends IBusinessExt> sdk;
    public Set<ExtensionSpec> extensions = Sets.newHashSet();

    public UseCaseSpec() {
        this.setPriority(100);
        this.setType(TemplateType.USE_CASE);
    }

    @Override
    public UseCaseTemplate newInstance() {
        if (null == this.useCaseClass) {
            return null;
        }
        try {
            return (UseCaseTemplate)this.useCaseClass.newInstance();
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            throw new LatticeRuntimeException("LATTICE-CORE-004", ex.getMessage());
        }
    }

    public Class<?> getUseCaseClass() {
        return this.useCaseClass;
    }

    public void setUseCaseClass(Class<?> useCaseClass) {
        this.useCaseClass = useCaseClass;
    }

    public Class<? extends IBusinessExt> getSdk() {
        return this.sdk;
    }

    public void setSdk(Class<? extends IBusinessExt> sdk) {
        this.sdk = sdk;
    }

    public Set<ExtensionSpec> getExtensions() {
        return this.extensions;
    }
}

