/*
 * Decompiled with CFR 0.152.
 */
package org.hiforce.lattice.spi;

import java.util.List;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.hiforce.lattice.spi.annotation.AbilityAnnotationParser;
import org.hiforce.lattice.spi.annotation.BusinessAnnotationParser;
import org.hiforce.lattice.spi.annotation.ExtensionAnnotationParser;
import org.hiforce.lattice.spi.annotation.PriorityAnnotationParser;
import org.hiforce.lattice.spi.annotation.ProductAnnotationParser;
import org.hiforce.lattice.spi.annotation.RealizationAnnotationParser;
import org.hiforce.lattice.spi.annotation.ScanSkipAnnotationParser;
import org.hiforce.lattice.spi.annotation.UseCaseAnnotationParser;

public class LatticeAnnotationSpiFactory {
    private static LatticeAnnotationSpiFactory instance;
    private static ClassLoader classLoader;
    private List<ExtensionAnnotationParser> extensionAnnotationParsers;
    private List<AbilityAnnotationParser> abilityAnnotationParsers;
    private List<ScanSkipAnnotationParser> scanSkipAnnotationParsers;
    private List<RealizationAnnotationParser> realizationAnnotationParsers;
    private List<ProductAnnotationParser> productAnnotationParsers;
    private List<BusinessAnnotationParser> businessAnnotationParsers;
    private List<UseCaseAnnotationParser> useCaseAnnotationParsers;
    private List<PriorityAnnotationParser> priorityAnnotationParsers;

    private LatticeAnnotationSpiFactory() {
    }

    public static LatticeAnnotationSpiFactory getInstance() {
        if (null == instance) {
            instance = new LatticeAnnotationSpiFactory();
            classLoader = LatticeAnnotationSpiFactory.class.getClassLoader();
        }
        return instance;
    }

    public List<PriorityAnnotationParser> getPriorityAnnotationParsers() {
        if (null == this.priorityAnnotationParsers) {
            this.priorityAnnotationParsers = this.getCustomServiceProviders(PriorityAnnotationParser.class);
        }
        return this.priorityAnnotationParsers;
    }

    public List<AbilityAnnotationParser> getAbilityAnnotationParsers() {
        if (null == this.abilityAnnotationParsers) {
            this.abilityAnnotationParsers = this.getCustomServiceProviders(AbilityAnnotationParser.class);
        }
        return this.abilityAnnotationParsers;
    }

    public List<ExtensionAnnotationParser> getExtensionAnnotationParsers() {
        if (null == this.extensionAnnotationParsers) {
            this.extensionAnnotationParsers = this.getCustomServiceProviders(ExtensionAnnotationParser.class);
        }
        return this.extensionAnnotationParsers;
    }

    public List<RealizationAnnotationParser> getRealizationAnnotationParsers() {
        if (null == this.realizationAnnotationParsers) {
            this.realizationAnnotationParsers = this.getCustomServiceProviders(RealizationAnnotationParser.class);
        }
        return this.realizationAnnotationParsers;
    }

    public List<UseCaseAnnotationParser> getUseCaseAnnotationParsers() {
        if (null == this.useCaseAnnotationParsers) {
            this.useCaseAnnotationParsers = this.getCustomServiceProviders(UseCaseAnnotationParser.class);
        }
        return this.useCaseAnnotationParsers;
    }

    public List<BusinessAnnotationParser> getBusinessAnnotationParsers() {
        if (null == this.businessAnnotationParsers) {
            this.businessAnnotationParsers = this.getCustomServiceProviders(BusinessAnnotationParser.class);
        }
        return this.businessAnnotationParsers;
    }

    public List<ProductAnnotationParser> getProductAnnotationParsers() {
        if (null == this.productAnnotationParsers) {
            this.productAnnotationParsers = this.getCustomServiceProviders(ProductAnnotationParser.class);
        }
        return this.productAnnotationParsers;
    }

    public List<ScanSkipAnnotationParser> getScanSkipAnnotationParsers() {
        if (null == this.scanSkipAnnotationParsers) {
            this.scanSkipAnnotationParsers = this.getCustomServiceProviders(ScanSkipAnnotationParser.class);
        }
        return this.scanSkipAnnotationParsers;
    }

    public <T> List<T> getCustomServiceProviders(Class<T> spiClass) {
        ServiceLoader<T> serializers = ServiceLoader.load(spiClass, classLoader);
        return StreamSupport.stream(serializers.spliterator(), false).distinct().collect(Collectors.toList());
    }
}

