/*
 * Decompiled with CFR 0.152.
 */
package org.hiforce.lattice.spi.annotation;

import com.google.auto.common.MoreElements;
import com.google.common.base.Optional;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.hiforce.lattice.utils.ServicesFileUtils;

public abstract class LatticeAnnotationProcessor
extends AbstractProcessor {
    public static final String MISSING_SERVICES_ERROR = "No service interfaces provided for element!";
    private final Multimap<String, String> providers = HashMultimap.create();

    public abstract Class<?> getServiceInterfaceClass();

    private void log(String msg) {
        if (this.processingEnv.getOptions().containsKey("debug")) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, msg);
        }
    }

    private void error(String msg, Element element, AnnotationMirror annotation) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg, element, annotation);
    }

    private void fatalError(String msg) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "FATAL ERROR: " + msg);
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        try {
            return this.processImpl(annotations, roundEnv);
        }
        catch (Exception e) {
            StringWriter writer = new StringWriter();
            e.printStackTrace(new PrintWriter(writer));
            this.fatalError(writer.toString());
            return true;
        }
    }

    private boolean processImpl(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            this.generateConfigFiles();
        } else {
            this.processAnnotations(annotations, roundEnv);
        }
        return true;
    }

    public abstract Class<? extends Annotation> getProcessAnnotationClass();

    public final ImmutableSet<String> getSupportedAnnotationTypes() {
        return ImmutableSet.of((Object)this.getProcessAnnotationClass().getName());
    }

    private void processAnnotations(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Set<? extends Element> elements = roundEnv.getElementsAnnotatedWith(this.getProcessAnnotationClass());
        this.log(annotations.toString());
        this.log(elements.toString());
        for (Element element : elements) {
            Optional optional;
            ExecutableElement executableElement;
            Element element2;
            TypeElement providerImplementer = null;
            if (element instanceof TypeElement) {
                providerImplementer = (TypeElement)element;
            }
            if (element.getKind() == ElementKind.METHOD && element instanceof ExecutableElement && (element2 = (executableElement = (ExecutableElement)element).getEnclosingElement()).getKind() == ElementKind.CLASS && element2 instanceof TypeElement) {
                providerImplementer = (TypeElement)executableElement.getEnclosingElement();
            }
            if (providerImplementer == null || !(optional = MoreElements.getAnnotationMirror((Element)element, this.getProcessAnnotationClass())).isPresent()) continue;
            AnnotationMirror annotationMirror = (AnnotationMirror)optional.get();
            Class<?> serviceClass = this.getServiceInterfaceClass();
            if (null == serviceClass) {
                this.error(MISSING_SERVICES_ERROR, element, annotationMirror);
                continue;
            }
            this.providers.put((Object)serviceClass.getName(), (Object)this.getBinaryName(providerImplementer));
        }
    }

    private void generateConfigFiles() {
        Filer filer = this.processingEnv.getFiler();
        for (String providerInterface : this.providers.keySet()) {
            String resourceFile = "META-INF/services/" + providerInterface;
            this.log("Working on resource file: " + resourceFile);
            try {
                TreeSet allServices = Sets.newTreeSet();
                try {
                    FileObject existingFile = filer.getResource(StandardLocation.CLASS_OUTPUT, "", resourceFile);
                    this.log("Looking for existing resource file at " + existingFile.toUri());
                    Set<String> oldServices = ServicesFileUtils.readServiceFile(existingFile.openInputStream());
                    this.log("Existing service entries: " + oldServices);
                    allServices.addAll(oldServices);
                }
                catch (IOException e) {
                    this.log("Resource file did not already exist.");
                }
                HashSet newServices = new HashSet(this.providers.get((Object)providerInterface));
                if (allServices.containsAll(newServices)) {
                    this.log("No new service entries being added.");
                    return;
                }
                allServices.addAll(newServices);
                this.log("New service file contents: " + allServices);
                FileObject fileObject = filer.createResource(StandardLocation.CLASS_OUTPUT, "", resourceFile, new Element[0]);
                OutputStream out = fileObject.openOutputStream();
                ServicesFileUtils.writeServiceFile(allServices, out);
                out.close();
                this.log("Wrote to: " + fileObject.toUri());
            }
            catch (IOException e) {
                this.fatalError("Unable to createPluginConfig " + resourceFile + ", " + e);
                return;
            }
        }
    }

    private String getBinaryName(TypeElement element) {
        return this.getBinaryNameImpl(element, element.getSimpleName().toString());
    }

    private String getBinaryNameImpl(TypeElement element, String className) {
        Element enclosingElement = element.getEnclosingElement();
        if (enclosingElement instanceof PackageElement) {
            PackageElement pkg = (PackageElement)enclosingElement;
            if (pkg.isUnnamed()) {
                return className;
            }
            return pkg.getQualifiedName() + "." + className;
        }
        TypeElement typeElement = (TypeElement)enclosingElement;
        return this.getBinaryNameImpl(typeElement, typeElement.getSimpleName() + "$" + className);
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.RELEASE_8;
    }
}

