/*
 * Decompiled with CFR 0.152.
 */
package org.hiforce.lattice.spi.classloader;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.iterators.IteratorEnumeration;
import org.jetbrains.annotations.Nullable;

public class LatticeClassLoader
extends ClassLoader {
    private final List<ClassLoader> customLoaders = Lists.newArrayList();

    public LatticeClassLoader(ClassLoader parent) {
        super(parent);
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        try {
            return super.loadClass(name);
        }
        catch (ClassNotFoundException ex) {
            for (ClassLoader loader : this.customLoaders) {
                try {
                    return loader.loadClass(name);
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
            }
            throw new ClassNotFoundException(name);
        }
    }

    @Override
    @Nullable
    public URL getResource(String name) {
        URL url = super.getResource(name);
        if (null != url) {
            return url;
        }
        return this.getCustomLoaders().stream().map(p -> p.getResource(name)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        ArrayList urls = Lists.newArrayList();
        Enumeration<URL> enumeration = super.getResources(name);
        while (enumeration.hasMoreElements()) {
            urls.add(enumeration.nextElement());
        }
        for (ClassLoader classLoader : this.getCustomLoaders()) {
            enumeration = classLoader.getResources(name);
            while (enumeration.hasMoreElements()) {
                urls.add(enumeration.nextElement());
            }
        }
        return new IteratorEnumeration(urls.iterator());
    }

    @Override
    @Nullable
    public InputStream getResourceAsStream(String name) {
        InputStream inputStream = super.getResourceAsStream(name);
        if (null != inputStream) {
            return inputStream;
        }
        return this.getCustomLoaders().stream().map(p -> p.getResourceAsStream(name)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public List<ClassLoader> getCustomLoaders() {
        return this.customLoaders;
    }
}

