/*
 * Decompiled with CFR 0.152.
 */
package org.hiforce.lattice.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class BizCodeUtils {
    public static boolean isCodesMatched(String code, String specificCode) {
        if (StringUtils.equals((CharSequence)code, (CharSequence)specificCode)) {
            return true;
        }
        if (!StringUtils.contains((CharSequence)code, (CharSequence)"*")) {
            return false;
        }
        return BizCodeUtils.isPatternCodeMatched(code, specificCode);
    }

    public static boolean isCodeMatched(String code, String specificCode) {
        if (StringUtils.equals((CharSequence)code, (CharSequence)specificCode)) {
            return true;
        }
        if (!StringUtils.contains((CharSequence)code, (CharSequence)"*")) {
            return false;
        }
        return BizCodeUtils.isPatternCodeMatched(code, specificCode);
    }

    public static boolean isPatternCodeMatched(String code, String specificCode) {
        String patternStr = code.startsWith("*.") ? BizCodeUtils.code2PrePattern(code) : BizCodeUtils.code2Pattern(code);
        Pattern pattern = Pattern.compile(patternStr);
        Matcher matcher = pattern.matcher(specificCode);
        return matcher.find();
    }

    private static String code2PrePattern(String code) {
        String pattern = code.replace(".", "\\.");
        pattern = pattern.replace("*", "[a-zA-Z\\._]*");
        return pattern + "$";
    }

    private static String code2Pattern(String code) {
        String pattern = code.replace(".", "\\.");
        pattern = pattern.replace("*", "[a-zA-Z\\._]*");
        return "^" + pattern;
    }
}

