/*
 * Decompiled with CFR 0.152.
 */
package org.hiforce.lattice.utils;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.hiforce.lattice.annotation.model.ExtensionAnnotation;
import org.hiforce.lattice.model.ability.IBusinessExt;
import org.hiforce.lattice.utils.LatticeAnnotationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BusinessExtUtils {
    private static final Logger log = LoggerFactory.getLogger(BusinessExtUtils.class);
    private static final Map<Class<?>, Set<String>> CODE_MAP = new ConcurrentHashMap();
    private static final Table<Class<?>, String, Method> EXT_METHOD_MAP = HashBasedTable.create();

    public static Method getExtensionMethod(IBusinessExt businessExt, String extCode, String scenario) {
        if (null == businessExt) {
            return null;
        }
        if (!BusinessExtUtils.supportedExtCodes(businessExt).contains(extCode)) {
            return null;
        }
        IBusinessExt subExt = businessExt.getBusinessExtByCode(extCode, scenario);
        return (Method)EXT_METHOD_MAP.get(subExt.getClass(), (Object)extCode);
    }

    public static Set<String> supportedExtCodes(IBusinessExt businessExt) {
        if (null == businessExt) {
            return Sets.newHashSet();
        }
        Class<?> key = businessExt.getClass();
        Set<String> result = CODE_MAP.get(key);
        if (CollectionUtils.isNotEmpty(result)) {
            return result;
        }
        Set supportedCodes = Sets.newConcurrentHashSet();
        supportedCodes.addAll(BusinessExtUtils.distinctSupportCodes(businessExt));
        try {
            for (Method method : businessExt.getClass().getMethods()) {
                ExtensionAnnotation annotation = LatticeAnnotationUtils.getExtensionAnnotation(method);
                if (null == annotation || !StringUtils.isNotEmpty((CharSequence)annotation.getCode())) continue;
                EXT_METHOD_MAP.put(key, (Object)annotation.getCode(), (Object)MethodUtils.getAccessibleMethod((Method)method));
                supportedCodes.add(annotation.getCode());
            }
        }
        catch (Throwable th) {
            log.warn(th.getMessage(), th);
        }
        if (null == CODE_MAP.get(key)) {
            CODE_MAP.put(key, supportedCodes);
        } else {
            CODE_MAP.get(key).addAll(supportedCodes);
        }
        return supportedCodes;
    }

    private static Set<String> distinctSupportCodes(IBusinessExt businessExt) {
        Set codes = Sets.newConcurrentHashSet();
        if (null == businessExt) {
            return Sets.newHashSet();
        }
        List<IBusinessExt> subBusinessLists = businessExt.getAllSubBusinessExt();
        for (IBusinessExt subBusinessExt : subBusinessLists) {
            if (null == subBusinessExt) continue;
            codes.addAll(BusinessExtUtils.supportedExtCodes(subBusinessExt));
        }
        return codes;
    }
}

