/*
 * Decompiled with CFR 0.152.
 */
package org.hiforce.lattice.utils;

import com.google.common.collect.Lists;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.hiforce.lattice.annotation.model.AbilityAnnotation;
import org.hiforce.lattice.annotation.model.BusinessAnnotation;
import org.hiforce.lattice.annotation.model.ExtensionAnnotation;
import org.hiforce.lattice.annotation.model.ProductAnnotation;
import org.hiforce.lattice.annotation.model.RealizationAnnotation;
import org.hiforce.lattice.annotation.model.ScanSkipAnnotation;
import org.hiforce.lattice.annotation.model.UseCaseAnnotation;
import org.hiforce.lattice.exception.LatticeRuntimeException;
import org.hiforce.lattice.model.ability.IBusinessExt;
import org.hiforce.lattice.spi.LatticeAnnotationSpiFactory;
import org.hiforce.lattice.spi.annotation.AbilityAnnotationParser;
import org.hiforce.lattice.spi.annotation.BusinessAnnotationParser;
import org.hiforce.lattice.spi.annotation.ExtensionAnnotationParser;
import org.hiforce.lattice.spi.annotation.ProductAnnotationParser;
import org.hiforce.lattice.spi.annotation.RealizationAnnotationParser;
import org.hiforce.lattice.spi.annotation.ScanSkipAnnotationParser;
import org.hiforce.lattice.spi.annotation.UseCaseAnnotationParser;
import org.hiforce.lattice.utils.LatticeClassUtils;
import org.springframework.core.annotation.AnnotationUtils;

public class LatticeAnnotationUtils
extends AnnotationUtils {
    private static final Map<Class<?>, Boolean> annotatedInterfaceCache = new WeakHashMap();

    public static ExtensionAnnotation getExtensionAnnotation(Method method) {
        for (ExtensionAnnotationParser parser : LatticeAnnotationSpiFactory.getInstance().getExtensionAnnotationParsers()) {
            Object annotation = LatticeAnnotationUtils.findAnnotation(method, parser.getAnnotationClass());
            if (null == annotation) continue;
            ExtensionAnnotation output = parser.buildAnnotationInfo(annotation);
            String extCode = StringUtils.isNotEmpty((CharSequence)output.getCode()) ? output.getCode() : String.format("%s#%s#%s", method.getReturnType().getSimpleName(), method.getName(), Arrays.stream(method.getParameterTypes()).map(p -> p.getSimpleName()).collect(Collectors.joining("_")));
            output.setCode(extCode);
            return output;
        }
        return null;
    }

    public static AbilityAnnotation getAbilityAnnotation(Class<?> abilityClass) {
        for (AbilityAnnotationParser parser : LatticeAnnotationSpiFactory.getInstance().getAbilityAnnotationParsers()) {
            Annotation annotation = AnnotationUtils.findAnnotation(abilityClass, parser.getAnnotationClass());
            if (null == annotation) continue;
            return parser.buildAnnotationInfo(annotation, abilityClass);
        }
        return null;
    }

    public static ProductAnnotation getProductAnnotation(Class targetClass) {
        for (ProductAnnotationParser parser : LatticeAnnotationSpiFactory.getInstance().getProductAnnotationParsers()) {
            Annotation annotation = AnnotationUtils.findAnnotation((Class)targetClass, parser.getAnnotationClass());
            if (null == annotation) continue;
            ProductAnnotation info = new ProductAnnotation();
            info.setName(parser.getName(annotation));
            info.setCode(parser.getCode(annotation));
            info.setDesc(parser.getDesc(annotation));
            info.setPriority(parser.getPriority(annotation));
            return info;
        }
        return null;
    }

    public static UseCaseAnnotation getUseCaseAnnotation(Class targetClass) {
        for (UseCaseAnnotationParser parser : LatticeAnnotationSpiFactory.getInstance().getUseCaseAnnotationParsers()) {
            Annotation annotation = AnnotationUtils.findAnnotation((Class)targetClass, parser.getAnnotationClass());
            if (null == annotation) continue;
            UseCaseAnnotation info = new UseCaseAnnotation();
            info.setName(parser.getName(annotation));
            info.setCode(parser.getCode(annotation));
            info.setDesc(parser.getDesc(annotation));
            info.setSdk(parser.getSdk(annotation));
            info.setPriority(parser.getPriority(annotation));
            return info;
        }
        return null;
    }

    public static BusinessAnnotation getBusinessAnnotation(Class targetClass) {
        for (BusinessAnnotationParser parser : LatticeAnnotationSpiFactory.getInstance().getBusinessAnnotationParsers()) {
            Annotation annotation = AnnotationUtils.findAnnotation((Class)targetClass, parser.getAnnotationClass());
            if (null == annotation) continue;
            BusinessAnnotation info = new BusinessAnnotation();
            info.setName(parser.getName(annotation));
            info.setCode(parser.getCode(annotation));
            info.setDesc(parser.getDesc(annotation));
            info.setPriority(parser.getPriority(annotation));
            return info;
        }
        return null;
    }

    public static RealizationAnnotation getRealizationAnnotation(Class targetClass) {
        for (RealizationAnnotationParser parser : LatticeAnnotationSpiFactory.getInstance().getRealizationAnnotationParsers()) {
            Annotation annotation = LatticeAnnotationUtils.findAnnotation((Class)targetClass, parser.getAnnotationClass());
            if (null == annotation) continue;
            RealizationAnnotation info = new RealizationAnnotation();
            info.setScenario(parser.getScenario(annotation));
            info.setCodes(parser.getCodes(annotation));
            if (!ClassUtils.isAssignable((Class)targetClass, IBusinessExt.class)) {
                throw new LatticeRuntimeException("LATTICE-CORE-005", targetClass.getName());
            }
            info.setBusinessExtClass(targetClass);
            return info;
        }
        return null;
    }

    public static ScanSkipAnnotation getScanSkipAnnotation(Method method) {
        for (ScanSkipAnnotationParser parser : LatticeAnnotationSpiFactory.getInstance().getScanSkipAnnotationParsers()) {
            Annotation annotation = AnnotationUtils.findAnnotation((Method)method, parser.getAnnotationClass());
            if (null == annotation) continue;
            return parser.buildAnnotationInfo(annotation);
        }
        return null;
    }

    public static ScanSkipAnnotation getScanSkipAnnotation(Class<?> targetClass) {
        for (ScanSkipAnnotationParser parser : LatticeAnnotationSpiFactory.getInstance().getScanSkipAnnotationParsers()) {
            Annotation annotation = AnnotationUtils.getAnnotation(targetClass, parser.getAnnotationClass());
            if (null == annotation) continue;
            return parser.buildAnnotationInfo(annotation);
        }
        return null;
    }

    public static <A extends Annotation> A findAnnotation(Method method, Class<A> annotationType) {
        if (null == method) {
            return null;
        }
        Object annotation = method.getAnnotation(annotationType);
        if (null != annotation) {
            return annotation;
        }
        annotation = AnnotationUtils.findAnnotation((Method)method, annotationType);
        if (null != annotation) {
            return annotation;
        }
        Class<?> clazz = method.getDeclaringClass();
        annotation = LatticeAnnotationUtils.searchOnInterfaces(method, annotationType, clazz.getInterfaces());
        while (annotation == null && (clazz = clazz.getSuperclass()) != null && !clazz.equals(Object.class)) {
            try {
                Method equivalentMethod = clazz.getDeclaredMethod(method.getName(), method.getParameterTypes());
                annotation = LatticeAnnotationUtils.getAnnotation((Method)equivalentMethod, annotationType);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (annotation != null) continue;
            annotation = LatticeAnnotationUtils.searchOnInterfaces(method, annotationType, clazz.getInterfaces());
        }
        return annotation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isInterfaceWithAnnotatedMethods(Class<?> iface) {
        Map<Class<?>, Boolean> map = annotatedInterfaceCache;
        synchronized (map) {
            Boolean flag = annotatedInterfaceCache.get(iface);
            if (flag != null) {
                return flag;
            }
            boolean found = false;
            for (Method ifcMethod : iface.getMethods()) {
                if (ifcMethod.getAnnotations().length <= 0) continue;
                found = true;
                break;
            }
            annotatedInterfaceCache.put(iface, found);
            return found;
        }
    }

    private static boolean isParameterIsEqual(Class<?>[] targetParams, Class<?>[] methodParams) {
        if (null == targetParams && null == methodParams) {
            return true;
        }
        if (null == targetParams || methodParams == null) {
            return false;
        }
        if (targetParams.length != methodParams.length) {
            return false;
        }
        for (int i = 0; i < targetParams.length; ++i) {
            if (LatticeClassUtils.isSubClassOf(targetParams[0], methodParams[0])) continue;
            return false;
        }
        return true;
    }

    private static List<Method> findSameNameMethodWithSameParamNum(Method targetMethod, Method[] methods) {
        ArrayList output = Lists.newArrayList();
        for (Method method : methods) {
            if (!StringUtils.equals((CharSequence)targetMethod.getName(), (CharSequence)method.getName()) || targetMethod.getParameterTypes().length != method.getParameterTypes().length || !LatticeAnnotationUtils.isParameterIsEqual(targetMethod.getParameterTypes(), method.getParameterTypes())) continue;
            output.add(method);
        }
        return output;
    }

    private static <A extends Annotation> A lowLevelSearchAnnotation(Method method, Class<A> annotationType, Class<?> iface) {
        Annotation annotation = null;
        try {
            Method equivalentMethod = iface.getMethod(method.getName(), method.getParameterTypes());
            annotation = LatticeAnnotationUtils.getAnnotation((Method)equivalentMethod, annotationType);
        }
        catch (NoSuchMethodException ex) {
            Method oneMethod;
            Method[] methods;
            Method[] methodArray = methods = iface.getMethods();
            int n = methodArray.length;
            for (int i = 0; !(i >= n || (oneMethod = methodArray[i]).getName().equals(method.getName()) && (annotation = LatticeAnnotationUtils.getAnnotation((Method)oneMethod, annotationType)) != null); ++i) {
            }
        }
        return (A)annotation;
    }

    private static <A extends Annotation> A searchOnInterfaces(Method method, Class<A> annotationType, Class<?>[] classes) {
        Annotation annotation = null;
        for (Class<?> clz : classes) {
            if (!LatticeAnnotationUtils.isInterfaceWithAnnotatedMethods(clz)) continue;
            List<Method> maybeMethods = LatticeAnnotationUtils.findSameNameMethodWithSameParamNum(method, clz.getMethods());
            if (CollectionUtils.isNotEmpty(maybeMethods)) {
                annotation = maybeMethods.size() == 1 ? LatticeAnnotationUtils.getAnnotation((Method)maybeMethods.get(0), annotationType) : (Annotation)LatticeAnnotationUtils.lowLevelSearchAnnotation(method, annotationType, clz);
            }
            if (annotation != null) break;
            Class<?>[] superIfcs = clz.getInterfaces();
            annotation = (Annotation)LatticeAnnotationUtils.searchOnInterfaces(method, annotationType, superIfcs);
        }
        return (A)annotation;
    }
}

