/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.dashboard.controller;

import com.alibaba.csp.sentinel.dashboard.discovery.AppInfo;
import com.alibaba.csp.sentinel.dashboard.discovery.AppManagement;
import com.alibaba.csp.sentinel.dashboard.discovery.MachineInfo;
import com.alibaba.csp.sentinel.dashboard.domain.Result;
import com.alibaba.csp.sentinel.dashboard.domain.vo.MachineInfoVo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/app"})
public class AppController {
    @Autowired
    private AppManagement appManagement;

    @GetMapping(value={"/names.json"})
    public Result<List<String>> queryApps(HttpServletRequest request) {
        return Result.ofSuccess(this.appManagement.getAppNames());
    }

    @GetMapping(value={"/briefinfos.json"})
    public Result<List<AppInfo>> queryAppInfos(HttpServletRequest request) {
        ArrayList<AppInfo> list = new ArrayList<AppInfo>(this.appManagement.getBriefApps());
        Collections.sort(list, Comparator.comparing(AppInfo::getApp));
        return Result.ofSuccess(list);
    }

    @GetMapping(value={"/{app}/machines.json"})
    public Result<List<MachineInfoVo>> getMachinesByApp(@PathVariable(value="app") String app) {
        AppInfo appInfo = this.appManagement.getDetailApp(app);
        if (appInfo == null) {
            return Result.ofSuccess(null);
        }
        ArrayList<MachineInfo> list = new ArrayList<MachineInfo>(appInfo.getMachines());
        Collections.sort(list, Comparator.comparing(MachineInfo::getApp).thenComparing(MachineInfo::getIp).thenComparingInt(MachineInfo::getPort));
        return Result.ofSuccess(MachineInfoVo.fromMachineInfoList(list));
    }

    @RequestMapping(value={"/{app}/machine/remove.json"})
    public Result<String> removeMachineById(@PathVariable(value="app") String app, @RequestParam(name="ip") String ip, @RequestParam(name="port") int port) {
        AppInfo appInfo = this.appManagement.getDetailApp(app);
        if (appInfo == null) {
            return Result.ofSuccess(null);
        }
        if (this.appManagement.removeMachine(app, ip, port)) {
            return Result.ofSuccessMsg("success");
        }
        return Result.ofFail(1, "remove failed");
    }
}

