/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.dashboard.controller.cluster;

import com.alibaba.csp.sentinel.dashboard.client.CommandNotFoundException;
import com.alibaba.csp.sentinel.dashboard.datasource.entity.SentinelVersion;
import com.alibaba.csp.sentinel.dashboard.discovery.AppManagement;
import com.alibaba.csp.sentinel.dashboard.domain.Result;
import com.alibaba.csp.sentinel.dashboard.domain.cluster.request.ClusterClientModifyRequest;
import com.alibaba.csp.sentinel.dashboard.domain.cluster.request.ClusterModifyRequest;
import com.alibaba.csp.sentinel.dashboard.domain.cluster.request.ClusterServerModifyRequest;
import com.alibaba.csp.sentinel.dashboard.domain.cluster.state.AppClusterClientStateWrapVO;
import com.alibaba.csp.sentinel.dashboard.domain.cluster.state.AppClusterServerStateWrapVO;
import com.alibaba.csp.sentinel.dashboard.domain.cluster.state.ClusterUniversalStatePairVO;
import com.alibaba.csp.sentinel.dashboard.domain.cluster.state.ClusterUniversalStateVO;
import com.alibaba.csp.sentinel.dashboard.service.ClusterConfigService;
import com.alibaba.csp.sentinel.dashboard.util.ClusterEntityUtils;
import com.alibaba.csp.sentinel.dashboard.util.VersionUtils;
import com.alibaba.csp.sentinel.util.StringUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/cluster"})
public class ClusterConfigController {
    private final Logger logger = LoggerFactory.getLogger(ClusterConfigController.class);
    private final SentinelVersion version140 = new SentinelVersion().setMajorVersion(1).setMinorVersion(4);
    @Autowired
    private AppManagement appManagement;
    @Autowired
    private ClusterConfigService clusterConfigService;
    private static final String KEY_MODE = "mode";

    @PostMapping(value={"/config/modify_single"})
    public Result<Boolean> apiModifyClusterConfig(@RequestBody String payload) {
        if (StringUtil.isBlank((String)payload)) {
            return Result.ofFail(-1, "empty request body");
        }
        try {
            JSONObject body = JSON.parseObject((String)payload);
            if (body.containsKey((Object)KEY_MODE)) {
                int mode = body.getInteger(KEY_MODE);
                switch (mode) {
                    case 0: {
                        ClusterClientModifyRequest data = (ClusterClientModifyRequest)JSON.parseObject((String)payload, ClusterClientModifyRequest.class);
                        Result<Boolean> res = this.checkValidRequest(data);
                        if (res != null) {
                            return res;
                        }
                        this.clusterConfigService.modifyClusterClientConfig(data).get();
                        return Result.ofSuccess(true);
                    }
                    case 1: {
                        ClusterServerModifyRequest d = (ClusterServerModifyRequest)JSON.parseObject((String)payload, ClusterServerModifyRequest.class);
                        Result<Boolean> r = this.checkValidRequest(d);
                        if (r != null) {
                            return r;
                        }
                        this.clusterConfigService.modifyClusterServerConfig(d).get();
                        return Result.ofSuccess(true);
                    }
                }
                return Result.ofFail(-1, "invalid mode");
            }
            return Result.ofFail(-1, "invalid parameter");
        }
        catch (ExecutionException ex) {
            this.logger.error("Error when modifying cluster config", ex.getCause());
            return this.errorResponse(ex);
        }
        catch (Throwable ex) {
            this.logger.error("Error when modifying cluster config", ex);
            return Result.ofFail(-1, ex.getMessage());
        }
    }

    private <T> Result<T> errorResponse(ExecutionException ex) {
        if (this.isNotSupported(ex.getCause())) {
            return this.unsupportedVersion();
        }
        return Result.ofThrowable(-1, ex.getCause());
    }

    @GetMapping(value={"/state_single"})
    public Result<ClusterUniversalStateVO> apiGetClusterState(@RequestParam String app, @RequestParam String ip, @RequestParam Integer port) {
        if (StringUtil.isEmpty((String)app)) {
            return Result.ofFail(-1, "app cannot be null or empty");
        }
        if (StringUtil.isEmpty((String)ip)) {
            return Result.ofFail(-1, "ip cannot be null or empty");
        }
        if (port == null || port <= 0) {
            return Result.ofFail(-1, "Invalid parameter: port");
        }
        if (!this.checkIfSupported(app, ip, port)) {
            return this.unsupportedVersion();
        }
        try {
            return (Result)((CompletableFuture)this.clusterConfigService.getClusterUniversalState(app, ip, port).thenApply(Result::ofSuccess)).get();
        }
        catch (ExecutionException ex) {
            this.logger.error("Error when fetching cluster state", ex.getCause());
            return this.errorResponse(ex);
        }
        catch (Throwable throwable) {
            this.logger.error("Error when fetching cluster state", throwable);
            return Result.ofFail(-1, throwable.getMessage());
        }
    }

    @GetMapping(value={"/server_state/{app}"})
    public Result<List<AppClusterServerStateWrapVO>> apiGetClusterServerStateOfApp(@PathVariable String app) {
        if (StringUtil.isEmpty((String)app)) {
            return Result.ofFail(-1, "app cannot be null or empty");
        }
        try {
            return (Result)((CompletableFuture)((CompletableFuture)this.clusterConfigService.getClusterUniversalState(app).thenApply(ClusterEntityUtils::wrapToAppClusterServerState)).thenApply(Result::ofSuccess)).get();
        }
        catch (ExecutionException ex) {
            this.logger.error("Error when fetching cluster server state of app: " + app, ex.getCause());
            return this.errorResponse(ex);
        }
        catch (Throwable throwable) {
            this.logger.error("Error when fetching cluster server state of app: " + app, throwable);
            return Result.ofFail(-1, throwable.getMessage());
        }
    }

    @GetMapping(value={"/client_state/{app}"})
    public Result<List<AppClusterClientStateWrapVO>> apiGetClusterClientStateOfApp(@PathVariable String app) {
        if (StringUtil.isEmpty((String)app)) {
            return Result.ofFail(-1, "app cannot be null or empty");
        }
        try {
            return (Result)((CompletableFuture)((CompletableFuture)this.clusterConfigService.getClusterUniversalState(app).thenApply(ClusterEntityUtils::wrapToAppClusterClientState)).thenApply(Result::ofSuccess)).get();
        }
        catch (ExecutionException ex) {
            this.logger.error("Error when fetching cluster token client state of app: " + app, ex.getCause());
            return this.errorResponse(ex);
        }
        catch (Throwable throwable) {
            this.logger.error("Error when fetching cluster token client state of app: " + app, throwable);
            return Result.ofFail(-1, throwable.getMessage());
        }
    }

    @GetMapping(value={"/state/{app}"})
    public Result<List<ClusterUniversalStatePairVO>> apiGetClusterStateOfApp(@PathVariable String app) {
        if (StringUtil.isEmpty((String)app)) {
            return Result.ofFail(-1, "app cannot be null or empty");
        }
        try {
            return (Result)((CompletableFuture)this.clusterConfigService.getClusterUniversalState(app).thenApply(Result::ofSuccess)).get();
        }
        catch (ExecutionException ex) {
            this.logger.error("Error when fetching cluster state of app: " + app, ex.getCause());
            return this.errorResponse(ex);
        }
        catch (Throwable throwable) {
            this.logger.error("Error when fetching cluster state of app: " + app, throwable);
            return Result.ofFail(-1, throwable.getMessage());
        }
    }

    private boolean isNotSupported(Throwable ex) {
        return ex instanceof CommandNotFoundException;
    }

    private boolean checkIfSupported(String app, String ip, int port) {
        try {
            return Optional.ofNullable(this.appManagement.getDetailApp(app)).flatMap(e -> e.getMachine(ip, port)).flatMap(m -> VersionUtils.parseVersion(m.getVersion()).map(v -> v.greaterOrEqual(this.version140))).orElse(true);
        }
        catch (Exception ex) {
            return true;
        }
    }

    private Result<Boolean> checkValidRequest(ClusterModifyRequest request) {
        if (StringUtil.isEmpty((String)request.getApp())) {
            return Result.ofFail(-1, "app cannot be empty");
        }
        if (StringUtil.isEmpty((String)request.getIp())) {
            return Result.ofFail(-1, "ip cannot be empty");
        }
        if (request.getPort() == null || request.getPort() < 0) {
            return Result.ofFail(-1, "invalid port");
        }
        if (request.getMode() == null || request.getMode() < 0) {
            return Result.ofFail(-1, "invalid mode");
        }
        if (!this.checkIfSupported(request.getApp(), request.getIp(), request.getPort())) {
            return this.unsupportedVersion();
        }
        return null;
    }

    private <R> Result<R> unsupportedVersion() {
        return Result.ofFail(4041, "Sentinel client not supported for cluster flow control (unsupported version or dependency absent)");
    }
}

