/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.dashboard.discovery;

import com.alibaba.csp.sentinel.dashboard.config.DashboardConfig;
import com.alibaba.csp.sentinel.dashboard.discovery.MachineInfo;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class AppInfo {
    private String app = "";
    private Integer appType = 0;
    private Set<MachineInfo> machines = ConcurrentHashMap.newKeySet();

    public AppInfo() {
    }

    public AppInfo(String app) {
        this.app = app;
    }

    public AppInfo(String app, Integer appType) {
        this.app = app;
        this.appType = appType;
    }

    public String getApp() {
        return this.app;
    }

    public void setApp(String app) {
        this.app = app;
    }

    public Integer getAppType() {
        return this.appType;
    }

    public void setAppType(Integer appType) {
        this.appType = appType;
    }

    public Set<MachineInfo> getMachines() {
        return new HashSet<MachineInfo>(this.machines);
    }

    public String toString() {
        return "AppInfo{app='" + this.app + ", machines=" + this.machines + '}';
    }

    public boolean addMachine(MachineInfo machineInfo) {
        this.machines.remove(machineInfo);
        return this.machines.add(machineInfo);
    }

    public synchronized boolean removeMachine(String ip, int port) {
        Iterator<MachineInfo> it = this.machines.iterator();
        while (it.hasNext()) {
            MachineInfo machine = it.next();
            if (!machine.getIp().equals(ip) || machine.getPort() != port) continue;
            it.remove();
            return true;
        }
        return false;
    }

    public Optional<MachineInfo> getMachine(String ip, int port) {
        return this.machines.stream().filter(e -> e.getIp().equals(ip) && e.getPort().equals(port)).findFirst();
    }

    private boolean heartbeatJudge(int threshold) {
        long healthyCount;
        if (this.machines.size() == 0) {
            return false;
        }
        if (threshold > 0 && (healthyCount = this.machines.stream().filter(MachineInfo::isHealthy).count()) == 0L) {
            return this.machines.stream().max(Comparator.comparingLong(MachineInfo::getLastHeartbeat)).map(e -> System.currentTimeMillis() - e.getLastHeartbeat() < (long)threshold).orElse(false);
        }
        return true;
    }

    public boolean isShown() {
        return this.heartbeatJudge(DashboardConfig.getHideAppNoMachineMillis());
    }

    public boolean isDead() {
        return !this.heartbeatJudge(DashboardConfig.getRemoveAppNoMachineMillis());
    }
}

