/*
 * Decompiled with CFR 0.152.
 */
package jodd.typeconverter;

import java.io.File;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import jodd.Jodd;
import jodd.datetime.JDateTime;
import jodd.mutable.MutableByte;
import jodd.mutable.MutableDouble;
import jodd.mutable.MutableFloat;
import jodd.mutable.MutableInteger;
import jodd.mutable.MutableLong;
import jodd.mutable.MutableShort;
import jodd.typeconverter.ConvertBean;
import jodd.typeconverter.TypeConversionException;
import jodd.typeconverter.TypeConverter;
import jodd.typeconverter.impl.BigDecimalConverter;
import jodd.typeconverter.impl.BigIntegerConverter;
import jodd.typeconverter.impl.BooleanArrayConverter;
import jodd.typeconverter.impl.BooleanConverter;
import jodd.typeconverter.impl.ByteArrayConverter;
import jodd.typeconverter.impl.ByteConverter;
import jodd.typeconverter.impl.CalendarConverter;
import jodd.typeconverter.impl.CharacterArrayConverter;
import jodd.typeconverter.impl.CharacterConverter;
import jodd.typeconverter.impl.ClassArrayConverter;
import jodd.typeconverter.impl.ClassConverter;
import jodd.typeconverter.impl.DateConverter;
import jodd.typeconverter.impl.DoubleArrayConverter;
import jodd.typeconverter.impl.DoubleConverter;
import jodd.typeconverter.impl.FileConverter;
import jodd.typeconverter.impl.FloatArrayConverter;
import jodd.typeconverter.impl.FloatConverter;
import jodd.typeconverter.impl.IntegerArrayConverter;
import jodd.typeconverter.impl.IntegerConverter;
import jodd.typeconverter.impl.JDateTimeConverter;
import jodd.typeconverter.impl.LocaleConverter;
import jodd.typeconverter.impl.LongArrayConverter;
import jodd.typeconverter.impl.LongConverter;
import jodd.typeconverter.impl.MutableByteConverter;
import jodd.typeconverter.impl.MutableDoubleConverter;
import jodd.typeconverter.impl.MutableFloatConverter;
import jodd.typeconverter.impl.MutableIntegerConverter;
import jodd.typeconverter.impl.MutableLongConverter;
import jodd.typeconverter.impl.MutableShortConverter;
import jodd.typeconverter.impl.ShortArrayConverter;
import jodd.typeconverter.impl.ShortConverter;
import jodd.typeconverter.impl.SqlDateConverter;
import jodd.typeconverter.impl.SqlTimeConverter;
import jodd.typeconverter.impl.SqlTimestampConverter;
import jodd.typeconverter.impl.StringArrayConverter;
import jodd.typeconverter.impl.StringConverter;
import jodd.typeconverter.impl.URIConverter;
import jodd.typeconverter.impl.URLConverter;
import jodd.util.ClassLoaderUtil;
import jodd.util.ReflectUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeConverterManagerBean {
    private final HashMap<Class, TypeConverter> converters = new HashMap(64);
    protected ConvertBean convertBean = new ConvertBean();

    public ConvertBean getConvertBean() {
        return this.convertBean;
    }

    public TypeConverterManagerBean() {
        this.registerDefaults();
    }

    public void registerDefaults() {
        this.register(String.class, new StringConverter());
        this.register(String[].class, new StringArrayConverter());
        IntegerConverter integerConverter = new IntegerConverter();
        this.register(Integer.class, integerConverter);
        this.register(Integer.TYPE, integerConverter);
        this.register(MutableInteger.class, new MutableIntegerConverter(this.convertBean));
        ShortConverter shortConverter = new ShortConverter();
        this.register(Short.class, shortConverter);
        this.register(Short.TYPE, shortConverter);
        this.register(MutableShort.class, new MutableShortConverter(this.convertBean));
        LongConverter longConverter = new LongConverter();
        this.register(Long.class, longConverter);
        this.register(Long.TYPE, longConverter);
        this.register(MutableLong.class, new MutableLongConverter(this.convertBean));
        ByteConverter byteConverter = new ByteConverter();
        this.register(Byte.class, byteConverter);
        this.register(Byte.TYPE, byteConverter);
        this.register(MutableByte.class, new MutableByteConverter(this.convertBean));
        FloatConverter floatConverter = new FloatConverter();
        this.register(Float.class, floatConverter);
        this.register(Float.TYPE, floatConverter);
        this.register(MutableFloat.class, new MutableFloatConverter(this.convertBean));
        DoubleConverter doubleConverter = new DoubleConverter();
        this.register(Double.class, doubleConverter);
        this.register(Double.TYPE, doubleConverter);
        this.register(MutableDouble.class, new MutableDoubleConverter(this.convertBean));
        BooleanConverter booleanConverter = new BooleanConverter();
        this.register(Boolean.class, booleanConverter);
        this.register(Boolean.TYPE, booleanConverter);
        CharacterConverter characterConverter = new CharacterConverter();
        this.register(Character.class, characterConverter);
        this.register(Character.TYPE, characterConverter);
        this.register(byte[].class, new ByteArrayConverter(this.convertBean));
        this.register(short[].class, new ShortArrayConverter(this.convertBean));
        this.register(int[].class, new IntegerArrayConverter(this.convertBean));
        this.register(long[].class, new LongArrayConverter(this.convertBean));
        this.register(float[].class, new FloatArrayConverter(this.convertBean));
        this.register(double[].class, new DoubleArrayConverter(this.convertBean));
        this.register(boolean[].class, new BooleanArrayConverter(this.convertBean));
        this.register(char[].class, new CharacterArrayConverter(this.convertBean));
        this.register(BigDecimal.class, new BigDecimalConverter());
        this.register(BigInteger.class, new BigIntegerConverter());
        this.register(java.util.Date.class, new DateConverter());
        this.register(Date.class, new SqlDateConverter());
        this.register(Time.class, new SqlTimeConverter());
        this.register(Timestamp.class, new SqlTimestampConverter());
        this.register(Calendar.class, new CalendarConverter());
        this.register(GregorianCalendar.class, new CalendarConverter());
        this.register(JDateTime.class, new JDateTimeConverter());
        this.register(File.class, new FileConverter());
        this.register(Class.class, new ClassConverter());
        this.register(Class[].class, new ClassArrayConverter(this.convertBean));
        this.register(URI.class, new URIConverter());
        this.register(URL.class, new URLConverter());
        this.register(Locale.class, new LocaleConverter());
        if (Jodd.isUploadLoaded()) {
            try {
                Class managerAddon = ClassLoaderUtil.loadClass("jodd.typeconverter.UploadTypeConverterManagerAddon");
                ReflectUtil.invoke(managerAddon, "registerDefaults", this);
            }
            catch (Exception ex) {
                throw new TypeConversionException(ex);
            }
        }
    }

    public void register(Class type, TypeConverter typeConverter) {
        this.convertBean.register(type, typeConverter);
        this.converters.put(type, typeConverter);
    }

    public void unregister(Class type) {
        this.convertBean.register(type, null);
        this.converters.remove(type);
    }

    public TypeConverter lookup(Class type) {
        return this.converters.get(type);
    }

    public <T> T convertType(Object value, Class<T> destinationType) {
        TypeConverter converter = this.lookup(destinationType);
        if (converter != null) {
            try {
                return converter.convert(value);
            }
            catch (TypeConversionException tcex) {
                throw new ClassCastException("Unable to convert to type: " + destinationType.getName() + '\n' + tcex.toString());
            }
        }
        if (value == null) {
            return null;
        }
        if (ReflectUtil.isInstanceOf(value, destinationType)) {
            return (T)value;
        }
        if (destinationType.isArray()) {
            Class<?> componentType = destinationType.getComponentType();
            if (!value.getClass().isArray()) {
                Object[] result = (Object[])Array.newInstance(componentType, 1);
                result[0] = this.convertType(value, componentType);
                return (T)result;
            }
            Object[] array = (Object[])value;
            Object[] result = (Object[])Array.newInstance(componentType, array.length);
            for (int i = 0; i < array.length; ++i) {
                result[i] = this.convertType(array[i], componentType);
            }
            return (T)result;
        }
        if (destinationType.isEnum()) {
            T[] enums = destinationType.getEnumConstants();
            String valStr = value.toString();
            for (T e : enums) {
                if (!e.toString().equals(valStr)) continue;
                return e;
            }
        }
        throw new ClassCastException("Unable to cast to type: " + destinationType.getName());
    }
}

