
package org.dmg.pmml.general_regression;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.RealNumberAdapter;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "BaselineCell", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions"
})
@Added((org.dmg.pmml.Version.PMML_4_0))
@JsonRootName("BaselineCell")
@JsonPropertyOrder({
    "time",
    "cumHazard",
    "extensions"
})
public class BaselineCell
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<BaselineCell>
{

    @XmlAttribute(name = "time", required = true)
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @JsonProperty("time")
    private Number time;
    @XmlAttribute(name = "cumHazard", required = true)
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @JsonProperty("cumHazard")
    private Number cumHazard;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    private final static long serialVersionUID = 67371010L;

    public BaselineCell() {
    }

    @ValueConstructor
    public BaselineCell(
        @org.jpmml.model.annotations.Property("time")
        Number time,
        @org.jpmml.model.annotations.Property("cumHazard")
        Number cumHazard) {
        this.time = time;
        this.cumHazard = cumHazard;
    }

    public Number getTime() {
        return time;
    }

    public BaselineCell setTime(
        @org.jpmml.model.annotations.Property("time")
        Number time) {
        this.time = time;
        return this;
    }

    public Number getCumHazard() {
        return cumHazard;
    }

    public BaselineCell setCumHazard(
        @org.jpmml.model.annotations.Property("cumHazard")
        Number cumHazard) {
        this.cumHazard = cumHazard;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public BaselineCell addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
