/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;

public class RootNode
extends Node {
    private transient DynamicScope scope;
    private StaticScope staticScope;
    private Node bodyNode;
    private String file;
    private int endPosition;

    public RootNode(ISourcePosition position, DynamicScope scope, Node bodyNode, String file2) {
        this(position, scope, bodyNode, file2, -1);
    }

    public RootNode(ISourcePosition position, DynamicScope scope, Node bodyNode, String file2, int endPosition) {
        super(position, bodyNode.containsVariableAssignment());
        assert (bodyNode != null) : "bodyNode is not null";
        this.scope = scope;
        this.staticScope = scope.getStaticScope();
        this.bodyNode = bodyNode;
        this.file = file2;
        this.endPosition = endPosition;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.ROOTNODE;
    }

    public DynamicScope getScope() {
        return this.scope;
    }

    public StaticScope getStaticScope() {
        return this.staticScope;
    }

    public String getFile() {
        return this.file;
    }

    public Node getBodyNode() {
        return this.bodyNode;
    }

    @Override
    public <T> T accept(NodeVisitor<T> iVisitor) {
        return iVisitor.visitRootNode(this);
    }

    @Override
    public List<Node> childNodes() {
        return RootNode.createList(this.bodyNode);
    }

    public boolean hasEndPosition() {
        return this.endPosition != -1;
    }

    public int getEndPosition() {
        return this.endPosition;
    }
}

