/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.operands;

import java.nio.charset.UnsupportedCharsetException;
import java.util.List;
import org.jruby.RubyString;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.OperandType;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class StringLiteral
extends Operand {
    public static final StringLiteral EMPTY_STRING = new StringLiteral("");
    public final ByteList bytelist;
    public final String string;
    public final int coderange;

    public StringLiteral(ByteList val, int coderange) {
        this(StringLiteral.internedStringFromByteList(val), val, coderange);
    }

    protected StringLiteral(String string2, ByteList bytelist, int coderange) {
        this.bytelist = bytelist;
        this.coderange = coderange;
        this.string = string2;
    }

    private static String internedStringFromByteList(ByteList val) {
        try {
            return Helpers.byteListToString(val).intern();
        }
        catch (UnsupportedCharsetException e) {
            return val.toString().intern();
        }
    }

    public StringLiteral(String s2) {
        this(s2, ByteList.create((CharSequence)s2));
    }

    private StringLiteral(String string2, ByteList byteList) {
        this.bytelist = byteList;
        this.string = string2;
        this.coderange = 16;
    }

    @Override
    public OperandType getOperandType() {
        return OperandType.STRING_LITERAL;
    }

    @Override
    public boolean hasKnownValue() {
        return true;
    }

    @Override
    public void addUsedVariables(List<Variable> l) {
    }

    public int hashCode() {
        return this.bytelist.hashCode();
    }

    public boolean equals(Object other) {
        return other instanceof StringLiteral && this.bytelist.equals((Object)((StringLiteral)other).bytelist) && this.coderange == ((StringLiteral)other).coderange;
    }

    public String toString() {
        return "\"" + this.string + "\"";
    }

    @Override
    public Operand cloneForInlining(CloneInfo ii) {
        return this;
    }

    @Override
    public Object retrieve(ThreadContext context, IRubyObject self2, StaticScope currScope, DynamicScope currDynScope, Object[] temp) {
        return RubyString.newStringShared(context.runtime, this.bytelist, this.coderange);
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.StringLiteral(this);
    }

    public ByteList getByteList() {
        return this.bytelist;
    }

    public String getString() {
        return this.string;
    }

    @Override
    public void encode(IRWriterEncoder e) {
        super.encode(e);
        e.encode(this.bytelist);
        e.encode(this.coderange);
    }

    public static StringLiteral decode(IRReaderDecoder d) {
        return new StringLiteral(d.decodeByteList(), d.decodeInt());
    }

    public int getCodeRange() {
        return this.coderange;
    }
}

