/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.maven.wagon;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Protocol;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSSessionCredentials;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.internal.Mimetypes;
import com.amazonaws.services.s3.internal.RepeatableFileInputStream;
import com.amazonaws.services.s3.model.CannedAccessControlList;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.amazonaws.services.s3.transfer.TransferManager;
import com.google.common.base.Optional;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.apache.maven.wagon.proxy.ProxyInfo;
import org.apache.maven.wagon.repository.Repository;
import org.apache.maven.wagon.repository.RepositoryPermissions;
import org.kuali.common.aws.s3.S3Utils;
import org.kuali.common.aws.s3.SimpleFormatter;
import org.kuali.common.threads.ElementHandler;
import org.kuali.common.threads.ExecutionStatistics;
import org.kuali.common.threads.ThreadHandlerContext;
import org.kuali.common.threads.ThreadInvoker;
import org.kuali.common.threads.listener.PercentCompleteListener;
import org.kuali.common.threads.listener.ProgressListener;
import org.kuali.maven.wagon.AbstractWagon;
import org.kuali.maven.wagon.FileHandler;
import org.kuali.maven.wagon.PutFileContext;
import org.kuali.maven.wagon.RequestFactory;
import org.kuali.maven.wagon.S3Listener;
import org.kuali.maven.wagon.TransferProgress;
import org.kuali.maven.wagon.TransferProgressFileInputStream;
import org.kuali.maven.wagon.TransferProgressFileOutputStream;
import org.kuali.maven.wagon.auth.AwsCredentials;
import org.kuali.maven.wagon.auth.AwsSessionCredentials;
import org.kuali.maven.wagon.auth.MavenAwsCredentialsProviderChain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class S3Wagon
extends AbstractWagon
implements RequestFactory {
    public static final String PROTOCOL_KEY = "maven.wagon.protocol";
    public static final String HTTP = "http";
    public static final String HTTP_ENDPOINT_VALUE = "http://s3.amazonaws.com";
    public static final String HTTPS = "https";
    public static final String MIN_THREADS_KEY = "maven.wagon.threads.min";
    public static final String MAX_THREADS_KEY = "maven.wagon.threads.max";
    public static final String DIVISOR_KEY = "maven.wagon.threads.divisor";
    public static final int DEFAULT_MIN_THREAD_COUNT = 10;
    public static final int DEFAULT_MAX_THREAD_COUNT = 50;
    public static final int DEFAULT_DIVISOR = 50;
    public static final int DEFAULT_READ_TIMEOUT = 60000;
    public static final CannedAccessControlList DEFAULT_ACL = CannedAccessControlList.PublicRead;
    private static final File TEMP_DIR = S3Wagon.getCanonicalFile(System.getProperty("java.io.tmpdir"));
    private static final String TEMP_DIR_PATH = TEMP_DIR.getAbsolutePath();
    ThreadInvoker invoker = new ThreadInvoker();
    SimpleFormatter formatter = new SimpleFormatter();
    int minThreads = this.getMinThreads();
    int maxThreads = this.getMaxThreads();
    int divisor = this.getDivisor();
    String protocol = this.getValue("maven.wagon.protocol", "https");
    boolean http = "http".equals(this.protocol);
    int readTimeout = 60000;
    CannedAccessControlList acl = DEFAULT_ACL;
    TransferManager transferManager;
    private static final Logger log = LoggerFactory.getLogger(S3Wagon.class);
    AmazonS3Client client;
    String bucketName;
    String basedir;
    private final Mimetypes mimeTypes = Mimetypes.getInstance();

    public S3Wagon() {
        super(true);
        S3Listener listener = new S3Listener();
        super.addSessionListener(listener);
        super.addTransferListener(listener);
    }

    protected void validateBucket(AmazonS3Client client, String bucketName) {
        log.debug("Looking for bucket: " + bucketName);
        if (client.doesBucketExist(bucketName)) {
            log.debug("Found bucket '" + bucketName + "' Validating permissions");
            this.validatePermissions(client, bucketName);
        } else {
            log.info("Creating bucket " + bucketName);
            client.createBucket(bucketName);
        }
    }

    protected void validatePermissions(AmazonS3Client client, String bucketName) {
        ListObjectsRequest zeroObjectsRequest = new ListObjectsRequest(bucketName, null, null, null, Integer.valueOf(0));
        client.listObjects(zeroObjectsRequest);
    }

    protected CannedAccessControlList getAclFromRepository(Repository repository) {
        RepositoryPermissions permissions = repository.getPermissions();
        if (permissions == null) {
            return null;
        }
        String filePermissions = permissions.getFileMode();
        if (StringUtils.isBlank((String)filePermissions)) {
            return null;
        }
        return CannedAccessControlList.valueOf((String)filePermissions.trim());
    }

    protected ClientConfiguration getClientConfiguration() {
        ClientConfiguration configuration = new ClientConfiguration();
        if (this.http) {
            log.info("http selected");
            configuration.setProtocol(Protocol.HTTP);
        }
        return configuration;
    }

    protected AmazonS3Client getAmazonS3Client(AWSCredentials credentials) {
        ClientConfiguration configuration = this.getClientConfiguration();
        return new AmazonS3Client(credentials, configuration);
    }

    @Override
    protected void connectToRepository(Repository source, AuthenticationInfo auth, ProxyInfo proxy) {
        AWSCredentials credentials = this.getCredentials(auth);
        this.client = this.getAmazonS3Client(credentials);
        this.transferManager = new TransferManager(credentials);
        this.bucketName = source.getHost();
        this.validateBucket(this.client, this.bucketName);
        this.basedir = this.getBaseDir(source);
        CannedAccessControlList repoAcl = this.getAclFromRepository(source);
        if (repoAcl != null) {
            log.info("File permissions: " + repoAcl.name());
            this.acl = repoAcl;
        }
    }

    @Override
    protected boolean doesRemoteResourceExist(String resourceName) {
        try {
            this.client.getObjectMetadata(this.bucketName, this.basedir + resourceName);
        }
        catch (AmazonClientException e) {
            return false;
        }
        return true;
    }

    @Override
    protected void disconnectFromRepository() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void getResource(String resourceName, File destination, TransferProgress progress) throws ResourceDoesNotExistException, IOException {
        S3Object object = null;
        try {
            String key = this.basedir + resourceName;
            object = this.client.getObject(this.bucketName, key);
        }
        catch (Exception e) {
            throw new ResourceDoesNotExistException("Resource " + resourceName + " does not exist in the repository", (Throwable)e);
        }
        S3ObjectInputStream in = null;
        TransferProgressFileOutputStream out = null;
        try {
            int length;
            in = object.getObjectContent();
            out = new TransferProgressFileOutputStream(destination, progress);
            byte[] buffer = new byte[1024];
            while ((length = in.read(buffer)) != -1) {
                ((OutputStream)out).write(buffer, 0, length);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly((InputStream)in);
            IOUtils.closeQuietly(out);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)in);
        IOUtils.closeQuietly((OutputStream)out);
    }

    @Override
    protected boolean isRemoteResourceNewer(String resourceName, long timestamp) {
        ObjectMetadata metadata = this.client.getObjectMetadata(this.bucketName, this.basedir + resourceName);
        return metadata.getLastModified().compareTo(new Date(timestamp)) < 0;
    }

    @Override
    protected List<String> listDirectory(String directory) throws Exception {
        if (StringUtils.isBlank((String)directory)) {
            directory = "";
        }
        String delimiter = "/";
        String prefix = this.basedir + directory;
        if (!prefix.endsWith(delimiter)) {
            prefix = prefix + delimiter;
        }
        ListObjectsRequest request = new ListObjectsRequest();
        request.setBucketName(this.bucketName);
        request.setPrefix(prefix);
        request.setDelimiter(delimiter);
        ObjectListing objectListing = this.client.listObjects(request);
        ArrayList<String> fileNames = new ArrayList<String>();
        for (S3ObjectSummary summary : objectListing.getObjectSummaries()) {
            String key = summary.getKey();
            String relativeKey = key.startsWith(this.basedir) ? key.substring(this.basedir.length()) : key;
            boolean add = !StringUtils.isBlank((String)relativeKey) && !relativeKey.equals(directory);
            if (!add) continue;
            fileNames.add(relativeKey);
        }
        for (String commonPrefix : objectListing.getCommonPrefixes()) {
            String value = commonPrefix.startsWith(this.basedir) ? commonPrefix.substring(this.basedir.length()) : commonPrefix;
            fileNames.add(value);
        }
        return fileNames;
    }

    protected void info(String msg) {
        System.out.println("[INFO] " + msg);
    }

    protected String getCanonicalKey(String key) {
        String path = this.basedir + key;
        File file = S3Wagon.getCanonicalFile(new File(TEMP_DIR, path));
        String canonical = file.getAbsolutePath();
        int pos = TEMP_DIR_PATH.length() + 1;
        String suffix = canonical.substring(pos);
        String canonicalKey = suffix.replace("\\", "/");
        return canonicalKey;
    }

    protected static File getCanonicalFile(String path) {
        return S3Wagon.getCanonicalFile(new File(path));
    }

    protected static File getCanonicalFile(File file) {
        try {
            return new File(file.getCanonicalPath());
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unexpected IO error", e);
        }
    }

    protected ObjectMetadata getObjectMetadata(File source, String destination) {
        String contentType = this.mimeTypes.getMimetype(destination);
        long contentLength = source.length();
        ObjectMetadata omd = new ObjectMetadata();
        omd.setContentLength(contentLength);
        omd.setContentType(contentType);
        return omd;
    }

    @Override
    public PutObjectRequest getPutObjectRequest(PutFileContext context) {
        File source = context.getSource();
        String destination = context.getDestination();
        TransferProgress progress = context.getProgress();
        return this.getPutObjectRequest(source, destination, progress);
    }

    protected InputStream getInputStream(File source, TransferProgress progress) throws FileNotFoundException {
        if (progress == null) {
            return new RepeatableFileInputStream(source);
        }
        return new TransferProgressFileInputStream(source, progress);
    }

    protected PutObjectRequest getPutObjectRequest(File source, String destination, TransferProgress progress) {
        try {
            String key = this.getCanonicalKey(destination);
            InputStream input = this.getInputStream(source, progress);
            ObjectMetadata metadata = this.getObjectMetadata(source, destination);
            PutObjectRequest request = new PutObjectRequest(this.bucketName, key, input, metadata);
            request.setCannedAcl(this.acl);
            return request;
        }
        catch (FileNotFoundException e) {
            throw new AmazonServiceException("File not found", (Exception)e);
        }
    }

    public final void putDirectory(File sourceDir, String destinationDir) throws TransferFailedException {
        List<PutFileContext> contexts = this.getPutFileContexts(sourceDir, destinationDir);
        for (PutFileContext context : contexts) {
            context.setProgress(null);
        }
        long bytes = this.sum(contexts);
        log.info(this.getUploadStartMsg(contexts.size(), bytes));
        ThreadHandlerContext thc = new ThreadHandlerContext();
        thc.setList(contexts);
        thc.setHandler((ElementHandler)new FileHandler());
        thc.setMax(this.maxThreads);
        thc.setMin(this.minThreads);
        thc.setDivisor(this.divisor);
        thc.setListener((ProgressListener)new PercentCompleteListener());
        ExecutionStatistics stats = this.invoker.invokeThreads(thc);
        long millis = stats.getExecutionTime();
        long count = stats.getIterationCount();
        log.info(this.getUploadCompleteMsg(millis, bytes, count));
    }

    protected String getUploadCompleteMsg(long millis, long bytes, long count) {
        String rate = this.formatter.getRate(millis, bytes);
        String time = this.formatter.getTime(millis);
        StringBuilder sb = new StringBuilder();
        sb.append("Files: " + count);
        sb.append("  Time: " + time);
        sb.append("  Rate: " + rate);
        return sb.toString();
    }

    protected String getUploadStartMsg(int fileCount, long bytes) {
        StringBuilder sb = new StringBuilder();
        sb.append("Files: " + fileCount);
        sb.append("  Bytes: " + this.formatter.getSize(bytes));
        return sb.toString();
    }

    protected int getRequestsPerThread(int threads, int requests) {
        int requestsPerThread = requests / threads;
        while (requestsPerThread * threads < requests) {
            ++requestsPerThread;
        }
        return requestsPerThread;
    }

    protected long sum(List<PutFileContext> contexts) {
        long sum = 0L;
        for (PutFileContext context : contexts) {
            File file = context.getSource();
            long length = file.length();
            sum += length;
        }
        return sum;
    }

    @Override
    protected void putResource(File source, String destination, TransferProgress progress) throws IOException {
        PutObjectRequest request = this.getPutObjectRequest(source, destination, progress);
        S3Utils.getInstance().upload(source, request, this.client, this.transferManager);
    }

    protected String getDestinationPath(String destination) {
        return destination.substring(0, destination.lastIndexOf(47));
    }

    protected String getBaseDir(Repository source) {
        StringBuilder sb = new StringBuilder(source.getBasedir());
        sb.deleteCharAt(0);
        if (sb.length() == 0) {
            return "";
        }
        if (sb.charAt(sb.length() - 1) != '/') {
            sb.append('/');
        }
        return sb.toString();
    }

    protected AWSCredentials getCredentials(AuthenticationInfo authenticationInfo) {
        Optional auth = Optional.fromNullable((Object)authenticationInfo);
        MavenAwsCredentialsProviderChain chain = new MavenAwsCredentialsProviderChain((Optional<AuthenticationInfo>)auth);
        AWSCredentials credentials = chain.getCredentials();
        if (credentials instanceof AWSSessionCredentials) {
            return new AwsSessionCredentials((AWSSessionCredentials)credentials);
        }
        return new AwsCredentials(credentials);
    }

    @Override
    protected PutFileContext getPutFileContext(File source, String destination) {
        PutFileContext context = super.getPutFileContext(source, destination);
        context.setFactory(this);
        context.setTransferManager(this.transferManager);
        context.setClient(this.client);
        return context;
    }

    protected int getMinThreads() {
        return this.getValue(MIN_THREADS_KEY, 10);
    }

    protected int getMaxThreads() {
        return this.getValue(MAX_THREADS_KEY, 50);
    }

    protected int getDivisor() {
        return this.getValue(DIVISOR_KEY, 50);
    }

    protected int getValue(String key, int defaultValue) {
        String value = System.getProperty(key);
        if (StringUtils.isEmpty((String)value)) {
            return defaultValue;
        }
        return new Integer(value);
    }

    protected String getValue(String key, String defaultValue) {
        String value = System.getProperty(key);
        if (StringUtils.isEmpty((String)value)) {
            return defaultValue;
        }
        return value;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }
}

