/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.maven.wagon.auth;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.google.common.base.Optional;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.kuali.maven.wagon.auth.Assert;
import org.kuali.maven.wagon.auth.AwsCredentials;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AuthenticationInfoCredentialsProvider
implements AWSCredentialsProvider {
    private final Optional<AuthenticationInfo> auth;

    public AuthenticationInfoCredentialsProvider(Optional<AuthenticationInfo> auth) {
        Assert.notNull(auth);
        this.auth = auth;
    }

    public AWSCredentials getCredentials() {
        if (!this.auth.isPresent()) {
            throw new IllegalStateException(this.getAuthenticationErrorMessage());
        }
        String accessKey = ((AuthenticationInfo)this.auth.get()).getUserName();
        String secretKey = ((AuthenticationInfo)this.auth.get()).getPassword();
        Assert.noBlanksWithMsg(this.getAuthenticationErrorMessage(), accessKey, secretKey);
        return new AwsCredentials(accessKey, secretKey);
    }

    public void refresh() {
    }

    protected String getAuthenticationErrorMessage() {
        StringBuffer sb = new StringBuffer();
        sb.append("The S3 wagon needs AWS Access Key set as the username and AWS Secret Key set as the password. eg:\n");
        sb.append("<server>\n");
        sb.append("  <id>my.server</id>\n");
        sb.append("  <username>[AWS Access Key ID]</username>\n");
        sb.append("  <password>[AWS Secret Access Key]</password>\n");
        sb.append("</server>\n");
        return sb.toString();
    }
}

