/*
 * Decompiled with CFR 0.152.
 */
package liquibase.snapshot.jvm;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Scanner;
import liquibase.database.AbstractJdbcDatabase;
import liquibase.database.Database;
import liquibase.database.core.DB2Database;
import liquibase.database.core.FirebirdDatabase;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.MySQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.database.jvm.JdbcConnection;
import liquibase.datatype.DataTypeFactory;
import liquibase.datatype.LiquibaseDataType;
import liquibase.datatype.core.BigIntType;
import liquibase.datatype.core.BlobType;
import liquibase.datatype.core.BooleanType;
import liquibase.datatype.core.CharType;
import liquibase.datatype.core.ClobType;
import liquibase.datatype.core.DateTimeType;
import liquibase.datatype.core.DateType;
import liquibase.datatype.core.DecimalType;
import liquibase.datatype.core.DoubleType;
import liquibase.datatype.core.FloatType;
import liquibase.datatype.core.IntType;
import liquibase.datatype.core.NCharType;
import liquibase.datatype.core.NVarcharType;
import liquibase.datatype.core.NumberType;
import liquibase.datatype.core.SmallIntType;
import liquibase.datatype.core.TimeType;
import liquibase.datatype.core.TimestampType;
import liquibase.datatype.core.TinyIntType;
import liquibase.datatype.core.VarcharType;
import liquibase.exception.DatabaseException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.executor.ExecutorService;
import liquibase.logging.LogFactory;
import liquibase.snapshot.CachedRow;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.InvalidExampleException;
import liquibase.snapshot.JdbcDatabaseSnapshot;
import liquibase.snapshot.jvm.JdbcSnapshotGenerator;
import liquibase.statement.DatabaseFunction;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.RawSqlStatement;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Column;
import liquibase.structure.core.DataType;
import liquibase.structure.core.Relation;
import liquibase.structure.core.Schema;
import liquibase.structure.core.Table;
import liquibase.structure.core.View;
import liquibase.util.StringUtils;

public class ColumnSnapshotGenerator
extends JdbcSnapshotGenerator {
    public ColumnSnapshotGenerator() {
        super(Column.class, new Class[]{Table.class, View.class});
    }

    @Override
    protected DatabaseObject snapshotObject(DatabaseObject example, DatabaseSnapshot snapshot) throws DatabaseException, InvalidExampleException {
        Database database = snapshot.getDatabase();
        Relation relation = ((Column)example).getRelation();
        Schema schema = relation.getSchema();
        List<CachedRow> columnMetadataRs = null;
        try {
            JdbcDatabaseSnapshot.CachingDatabaseMetaData databaseMetaData = ((JdbcDatabaseSnapshot)snapshot).getMetaData();
            columnMetadataRs = databaseMetaData.getColumns(((AbstractJdbcDatabase)database).getJdbcCatalogName(schema), ((AbstractJdbcDatabase)database).getJdbcSchemaName(schema), relation.getName(), example.getName());
            if (columnMetadataRs.size() > 0) {
                CachedRow data = columnMetadataRs.get(0);
                return this.readColumn(data, relation, database);
            }
            return null;
        }
        catch (Exception e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    protected void addTo(DatabaseObject foundObject, DatabaseSnapshot snapshot) throws DatabaseException, InvalidExampleException {
        if (!snapshot.getSnapshotControl().shouldInclude(Column.class)) {
            return;
        }
        if (foundObject instanceof Relation) {
            Database database = snapshot.getDatabase();
            Relation relation = (Relation)foundObject;
            List<CachedRow> allColumnsMetadataRs = null;
            try {
                JdbcDatabaseSnapshot.CachingDatabaseMetaData databaseMetaData = ((JdbcDatabaseSnapshot)snapshot).getMetaData();
                Schema schema = relation.getSchema();
                allColumnsMetadataRs = databaseMetaData.getColumns(((AbstractJdbcDatabase)database).getJdbcCatalogName(schema), ((AbstractJdbcDatabase)database).getJdbcSchemaName(schema), relation.getName(), null);
                for (CachedRow row : allColumnsMetadataRs) {
                    Column exampleColumn = new Column().setRelation(relation).setName(row.getString("COLUMN_NAME"));
                    relation.getColumns().add(exampleColumn);
                }
            }
            catch (Exception e) {
                throw new DatabaseException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Column readColumn(CachedRow columnMetadataResultSet, Relation table, Database database) throws SQLException, DatabaseException {
        String rawTableName = (String)columnMetadataResultSet.get("TABLE_NAME");
        String rawColumnName = (String)columnMetadataResultSet.get("COLUMN_NAME");
        String rawSchemaName = StringUtils.trimToNull((String)columnMetadataResultSet.get("TABLE_SCHEM"));
        String rawCatalogName = StringUtils.trimToNull((String)columnMetadataResultSet.get("TABLE_CAT"));
        String remarks = StringUtils.trimToNull((String)columnMetadataResultSet.get("REMARKS"));
        if (remarks != null) {
            remarks = remarks.replace("''", "'");
        }
        Column column = new Column();
        column.setName(rawColumnName);
        column.setRelation(table);
        column.setRemarks(remarks);
        if (database instanceof OracleDatabase) {
            String nullable = columnMetadataResultSet.getString("NULLABLE");
            if (nullable.equals("Y")) {
                column.setNullable(true);
            } else {
                column.setNullable(false);
            }
        } else {
            int nullable = columnMetadataResultSet.getInt("NULLABLE");
            if (nullable == 0) {
                column.setNullable(false);
            } else if (nullable == 1) {
                column.setNullable(true);
            } else if (nullable == 2) {
                LogFactory.getLogger().info("Unknown nullable state for column " + column.toString() + ". Assuming nullable");
                column.setNullable(true);
            }
        }
        if (database.supportsAutoIncrement() && table instanceof Table) {
            if (columnMetadataResultSet.containsColumn("IS_AUTOINCREMENT")) {
                String isAutoincrement = (String)columnMetadataResultSet.get("IS_AUTOINCREMENT");
                if ((isAutoincrement = StringUtils.trimToNull(isAutoincrement)) == null) {
                    column.setAutoIncrementInformation(null);
                } else if (isAutoincrement.equals("YES")) {
                    column.setAutoIncrementInformation(new Column.AutoIncrementInformation());
                } else if (isAutoincrement.equals("NO")) {
                    column.setAutoIncrementInformation(null);
                } else {
                    if (!isAutoincrement.equals("")) throw new UnexpectedLiquibaseException("Unknown is_autoincrement value: '" + isAutoincrement + "'");
                    LogFactory.getLogger().info("Unknown auto increment state for column " + column.toString() + ". Assuming not auto increment");
                    column.setAutoIncrementInformation(null);
                }
            } else {
                String selectStatement = "select " + database.escapeColumnName(rawCatalogName, rawSchemaName, rawTableName, rawColumnName) + " from " + database.escapeTableName(rawCatalogName, rawSchemaName, rawTableName) + " where 0=1";
                LogFactory.getLogger().debug("Checking " + rawTableName + "." + rawCatalogName + " for auto-increment with SQL: '" + selectStatement + "'");
                Connection underlyingConnection = ((JdbcConnection)database.getConnection()).getUnderlyingConnection();
                Statement statement = null;
                ResultSet columnSelectRS = null;
                try {
                    statement = underlyingConnection.createStatement();
                    columnSelectRS = statement.executeQuery(selectStatement);
                    if (columnSelectRS.getMetaData().isAutoIncrement(1)) {
                        column.setAutoIncrementInformation(new Column.AutoIncrementInformation());
                    } else {
                        column.setAutoIncrementInformation(null);
                    }
                }
                finally {
                    try {
                        if (statement != null) {
                            statement.close();
                        }
                    }
                    catch (SQLException ignore) {}
                    if (columnSelectRS != null) {
                        columnSelectRS.close();
                    }
                }
            }
        }
        DataType type = this.readDataType(columnMetadataResultSet, column, database);
        column.setType(type);
        column.setDefaultValue(this.readDefaultValue(columnMetadataResultSet, column, database));
        return column;
    }

    protected DataType readDataType(CachedRow columnMetadataResultSet, Column column, Database database) throws SQLException {
        String typeName;
        Integer decimalDigits;
        if (database instanceof OracleDatabase) {
            String dataType = columnMetadataResultSet.getString("DATA_TYPE");
            dataType = dataType.replace("VARCHAR2", "VARCHAR");
            dataType = dataType.replace("NVARCHAR2", "NVARCHAR");
            DataType type = new DataType(dataType);
            if (dataType.equalsIgnoreCase("NUMBER")) {
                type.setColumnSize(columnMetadataResultSet.getInt("DATA_PRECISION"));
                if (type.getColumnSize() == null) {
                    type.setColumnSize(38);
                }
                type.setDecimalDigits(columnMetadataResultSet.getInt("DATA_SCALE"));
            } else {
                type.setColumnSize(columnMetadataResultSet.getInt("DATA_LENGTH"));
                if (!dataType.equalsIgnoreCase("NCLOB")) {
                    if (dataType.equalsIgnoreCase("NVARCHAR") || dataType.equalsIgnoreCase("NCHAR")) {
                        type.setColumnSize(type.getColumnSize() / 2);
                        type.setColumnSizeUnit(DataType.ColumnSizeUnit.CHAR);
                    } else {
                        String charUsed = columnMetadataResultSet.getString("CHAR_USED");
                        DataType.ColumnSizeUnit unit = null;
                        if ("C".equals(charUsed)) {
                            unit = DataType.ColumnSizeUnit.CHAR;
                        }
                        type.setColumnSizeUnit(unit);
                    }
                }
            }
            return type;
        }
        String columnTypeName = (String)columnMetadataResultSet.get("TYPE_NAME");
        if (database instanceof FirebirdDatabase) {
            if (columnTypeName.equals("BLOB SUB_TYPE 0")) {
                columnTypeName = "BLOB";
            }
            if (columnTypeName.equals("BLOB SUB_TYPE 1")) {
                columnTypeName = "CLOB";
            }
        }
        if (database instanceof MySQLDatabase && (columnTypeName.equalsIgnoreCase("ENUM") || columnTypeName.equalsIgnoreCase("SET"))) {
            try {
                String boilerLength = columnTypeName.equalsIgnoreCase("ENUM") ? "7" : "6";
                List enumValues = ExecutorService.getInstance().getExecutor(database).queryForList((SqlStatement)new RawSqlStatement("SELECT DISTINCT SUBSTRING_INDEX(SUBSTRING_INDEX(SUBSTRING(COLUMN_TYPE, " + boilerLength + ", LENGTH(COLUMN_TYPE) - " + boilerLength + " - 1 ), \"','\", 1 + units.i + tens.i * 10) , \"','\", -1)\n" + "FROM INFORMATION_SCHEMA.COLUMNS\n" + "CROSS JOIN (SELECT 0 AS i UNION SELECT 1 UNION SELECT 2 UNION SELECT 3 UNION SELECT 4 UNION SELECT 5 UNION SELECT 6 UNION SELECT 7 UNION SELECT 8 UNION SELECT 9) units\n" + "CROSS JOIN (SELECT 0 AS i UNION SELECT 1 UNION SELECT 2 UNION SELECT 3 UNION SELECT 4 UNION SELECT 5 UNION SELECT 6 UNION SELECT 7 UNION SELECT 8 UNION SELECT 9) tens\n" + "WHERE TABLE_NAME = '" + column.getRelation().getName() + "' \n" + "AND COLUMN_NAME = '" + column.getName() + "'"), String.class);
                String enumClause = "";
                for (String enumValue : enumValues) {
                    enumClause = enumClause + "'" + enumValue + "', ";
                }
                enumClause = enumClause.replaceFirst(", $", "");
                return new DataType(columnTypeName + "(" + enumClause + ")");
            }
            catch (DatabaseException e) {
                LogFactory.getLogger().warning("Error fetching enum values", e);
            }
        }
        DataType.ColumnSizeUnit columnSizeUnit = DataType.ColumnSizeUnit.BYTE;
        int dataType = columnMetadataResultSet.getInt("DATA_TYPE");
        Integer columnSize = columnMetadataResultSet.getInt("COLUMN_SIZE");
        if (database.dataTypeIsNotModifiable(columnTypeName)) {
            columnSize = null;
        }
        if ((decimalDigits = columnMetadataResultSet.getInt("DECIMAL_DIGITS")) != null && decimalDigits.equals(0)) {
            decimalDigits = null;
        }
        Integer radix = columnMetadataResultSet.getInt("NUM_PREC_RADIX");
        Integer characterOctetLength = columnMetadataResultSet.getInt("CHAR_OCTET_LENGTH");
        if (database instanceof DB2Database && ((typeName = columnMetadataResultSet.getString("TYPE_NAME")).equalsIgnoreCase("DBCLOB") || typeName.equalsIgnoreCase("GRAPHIC") || typeName.equalsIgnoreCase("VARGRAPHIC")) && columnSize != null) {
            columnSize = columnSize / 2;
        }
        DataType type = new DataType(columnTypeName);
        type.setDataTypeId(dataType);
        type.setColumnSize(columnSize);
        type.setDecimalDigits(decimalDigits);
        type.setRadix(radix);
        type.setCharacterOctetLength(characterOctetLength);
        type.setColumnSizeUnit(columnSizeUnit);
        return type;
    }

    protected Object readDefaultValue(CachedRow columnMetadataResultSet, Column columnInfo, Database database) throws SQLException, DatabaseException {
        Object val;
        Object defaultValue;
        if (database instanceof MSSQLDatabase && (defaultValue = columnMetadataResultSet.get("COLUMN_DEF")) != null && defaultValue instanceof String && defaultValue.equals("(NULL)")) {
            columnMetadataResultSet.set("COLUMN_DEF", null);
        }
        if (database instanceof OracleDatabase && columnMetadataResultSet.get("COLUMN_DEF") == null) {
            columnMetadataResultSet.set("COLUMN_DEF", columnMetadataResultSet.get("DATA_DEFAULT"));
        }
        if (!((val = columnMetadataResultSet.get("COLUMN_DEF")) instanceof String)) {
            return val;
        }
        String stringVal = (String)val;
        if (stringVal.isEmpty()) {
            return null;
        }
        if (stringVal.startsWith("'") && stringVal.endsWith("'")) {
            stringVal = stringVal.substring(1, stringVal.length() - 1);
        } else if (stringVal.startsWith("((") && stringVal.endsWith("))")) {
            stringVal = stringVal.substring(2, stringVal.length() - 2);
        } else if (stringVal.startsWith("('") && stringVal.endsWith("')")) {
            stringVal = stringVal.substring(2, stringVal.length() - 2);
        } else if (stringVal.startsWith("(") && stringVal.endsWith(")")) {
            return new DatabaseFunction(stringVal.substring(1, stringVal.length() - 1));
        }
        int type = Integer.MIN_VALUE;
        if (columnInfo.getType().getDataTypeId() != null) {
            type = columnInfo.getType().getDataTypeId();
        }
        String typeName = columnInfo.getType().getTypeName();
        Scanner scanner = new Scanner(stringVal.trim());
        LiquibaseDataType liquibaseDataType = DataTypeFactory.getInstance().from(columnInfo.getType());
        if (type == 2003) {
            return new DatabaseFunction(stringVal);
        }
        if (liquibaseDataType instanceof BigIntType || type == -5) {
            if (scanner.hasNextBigInteger()) {
                return scanner.nextBigInteger();
            }
            return new DatabaseFunction(stringVal);
        }
        if (type == -2) {
            return new DatabaseFunction(stringVal.trim());
        }
        if (type == -7) {
            if (stringVal.startsWith("b'")) {
                stringVal = stringVal.replaceFirst("b'", "").replaceFirst("'$", "");
            }
            stringVal = stringVal.trim();
            if (scanner.hasNextBoolean()) {
                return scanner.nextBoolean();
            }
            return new Integer(stringVal);
        }
        if (liquibaseDataType instanceof BlobType || type == 2004) {
            return new DatabaseFunction(stringVal);
        }
        if (liquibaseDataType instanceof BooleanType || type == 16) {
            if (scanner.hasNextBoolean()) {
                return scanner.nextBoolean();
            }
            return new DatabaseFunction(stringVal);
        }
        if (liquibaseDataType instanceof CharType || type == 1) {
            return stringVal;
        }
        if (liquibaseDataType instanceof ClobType || type == 2005) {
            return stringVal;
        }
        if (type == 70) {
            return new DatabaseFunction(stringVal);
        }
        if (liquibaseDataType instanceof DateType || type == 91) {
            if (typeName.equalsIgnoreCase("year")) {
                return stringVal.trim();
            }
            return DataTypeFactory.getInstance().fromDescription("date").sqlToObject(stringVal, database);
        }
        if (liquibaseDataType instanceof DecimalType || type == 3) {
            if (scanner.hasNextBigDecimal()) {
                return scanner.nextBigDecimal();
            }
            return new DatabaseFunction(stringVal);
        }
        if (type == 2001) {
            return new DatabaseFunction(stringVal);
        }
        if (liquibaseDataType instanceof DoubleType || type == 8) {
            if (scanner.hasNextDouble()) {
                return scanner.nextDouble();
            }
            return new DatabaseFunction(stringVal);
        }
        if (liquibaseDataType instanceof FloatType || type == 6) {
            if (scanner.hasNextFloat()) {
                return Float.valueOf(scanner.nextFloat());
            }
            return new DatabaseFunction(stringVal);
        }
        if (liquibaseDataType instanceof IntType || type == 4) {
            if (scanner.hasNextInt()) {
                return scanner.nextInt();
            }
            return new DatabaseFunction(stringVal);
        }
        if (type == 2000) {
            return new DatabaseFunction(stringVal);
        }
        if (type == -16) {
            return stringVal;
        }
        if (type == -4) {
            return new DatabaseFunction(stringVal);
        }
        if (type == -1) {
            return stringVal;
        }
        if (liquibaseDataType instanceof NCharType || type == -15) {
            return stringVal;
        }
        if (type == 2011) {
            return stringVal;
        }
        if (type == 0) {
            return null;
        }
        if (liquibaseDataType instanceof NumberType || type == 2) {
            if (scanner.hasNextBigDecimal()) {
                return scanner.nextBigDecimal();
            }
            return new DatabaseFunction(stringVal);
        }
        if (liquibaseDataType instanceof NVarcharType || type == -9) {
            return stringVal;
        }
        if (type == 1111) {
            if (database instanceof DB2Database && typeName.equalsIgnoreCase("DECFLOAT")) {
                return new BigDecimal(stringVal);
            }
            return new DatabaseFunction(stringVal);
        }
        if (type == 7) {
            return new BigDecimal(stringVal.trim());
        }
        if (type == 2006) {
            return new DatabaseFunction(stringVal);
        }
        if (type == -8) {
            return new DatabaseFunction(stringVal);
        }
        if (liquibaseDataType instanceof SmallIntType || type == 5) {
            if (scanner.hasNextInt()) {
                return scanner.nextInt();
            }
            return new DatabaseFunction(stringVal);
        }
        if (type == 2009) {
            return new DatabaseFunction(stringVal);
        }
        if (type == 2002) {
            return new DatabaseFunction(stringVal);
        }
        if (liquibaseDataType instanceof TimeType || type == 92) {
            return DataTypeFactory.getInstance().fromDescription("time").sqlToObject(stringVal, database);
        }
        if (liquibaseDataType instanceof DateTimeType || liquibaseDataType instanceof TimestampType || type == 93) {
            return DataTypeFactory.getInstance().fromDescription("datetime").sqlToObject(stringVal, database);
        }
        if (liquibaseDataType instanceof TinyIntType || type == -6) {
            if (scanner.hasNextInt()) {
                return scanner.nextInt();
            }
            return new DatabaseFunction(stringVal);
        }
        if (type == -3) {
            return new DatabaseFunction(stringVal);
        }
        if (liquibaseDataType instanceof VarcharType || type == 12) {
            return stringVal;
        }
        if (database instanceof MySQLDatabase && typeName.toLowerCase().startsWith("enum")) {
            return stringVal;
        }
        LogFactory.getLogger().info("Unknown default value: value '" + stringVal + "' type " + typeName + " (" + type + "), assuming it is a function");
        return new DatabaseFunction(stringVal);
    }
}

