/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.shaded.freemarker.core;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.mapstruct.ap.shaded.freemarker.core.Assignment;
import org.mapstruct.ap.shaded.freemarker.core.Environment;
import org.mapstruct.ap.shaded.freemarker.core.Expression;
import org.mapstruct.ap.shaded.freemarker.core.NonNamespaceException;
import org.mapstruct.ap.shaded.freemarker.core.ParameterRole;
import org.mapstruct.ap.shaded.freemarker.core.TemplateElement;
import org.mapstruct.ap.shaded.freemarker.template.SimpleScalar;
import org.mapstruct.ap.shaded.freemarker.template.TemplateException;
import org.mapstruct.ap.shaded.freemarker.template.TemplateModel;
import org.mapstruct.ap.shaded.freemarker.template.TemplateTransformModel;

final class BlockAssignment
extends TemplateElement {
    private final String varName;
    private final Expression namespaceExp;
    private final int scope;

    BlockAssignment(TemplateElement nestedBlock, String varName, int scope, Expression namespaceExp) {
        this.nestedBlock = nestedBlock;
        this.varName = varName;
        this.namespaceExp = namespaceExp;
        this.scope = scope;
    }

    void accept(Environment env) throws TemplateException, IOException {
        if (this.nestedBlock != null) {
            env.visitAndTransform(this.nestedBlock, new CaptureOutput(env), null);
        } else {
            SimpleScalar value = new SimpleScalar("");
            if (this.namespaceExp != null) {
                Environment.Namespace ns = (Environment.Namespace)this.namespaceExp.eval(env);
                ns.put(this.varName, value);
            } else if (this.scope == 1) {
                env.setVariable(this.varName, value);
            } else if (this.scope == 3) {
                env.setGlobalVariable(this.varName, value);
            } else if (this.scope == 2) {
                env.setLocalVariable(this.varName, value);
            }
        }
    }

    protected String dump(boolean canonical) {
        StringBuffer sb = new StringBuffer();
        if (canonical) {
            sb.append("<");
        }
        sb.append(this.getNodeTypeSymbol());
        sb.append(' ');
        sb.append(this.varName);
        if (this.namespaceExp != null) {
            sb.append(" in ");
            sb.append(this.namespaceExp.getCanonicalForm());
        }
        if (canonical) {
            sb.append('>');
            sb.append(this.nestedBlock == null ? "" : this.nestedBlock.getCanonicalForm());
            sb.append("</");
            sb.append(this.getNodeTypeSymbol());
            sb.append('>');
        } else {
            sb.append(" = .nested_output");
        }
        return sb.toString();
    }

    String getNodeTypeSymbol() {
        return Assignment.getDirectiveName(this.scope);
    }

    int getParameterCount() {
        return 3;
    }

    Object getParameterValue(int idx) {
        switch (idx) {
            case 0: {
                return this.varName;
            }
            case 1: {
                return new Integer(this.scope);
            }
            case 2: {
                return this.namespaceExp;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    ParameterRole getParameterRole(int idx) {
        switch (idx) {
            case 0: {
                return ParameterRole.ASSIGNMENT_TARGET;
            }
            case 1: {
                return ParameterRole.VARIABLE_SCOPE;
            }
            case 2: {
                return ParameterRole.NAMESPACE;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    boolean isIgnorable() {
        return false;
    }

    private class CaptureOutput
    implements TemplateTransformModel {
        private final Environment env;
        private final Environment.Namespace fnsModel;

        CaptureOutput(Environment env) throws TemplateException {
            this.env = env;
            TemplateModel nsModel = null;
            if (BlockAssignment.this.namespaceExp != null && !((nsModel = BlockAssignment.this.namespaceExp.eval(env)) instanceof Environment.Namespace)) {
                throw new NonNamespaceException(BlockAssignment.this.namespaceExp, nsModel, env);
            }
            this.fnsModel = (Environment.Namespace)nsModel;
        }

        public Writer getWriter(Writer out, Map args) {
            return new StringWriter(){

                public void close() {
                    SimpleScalar result = new SimpleScalar(this.toString());
                    switch (BlockAssignment.this.scope) {
                        case 1: {
                            if (CaptureOutput.this.fnsModel != null) {
                                CaptureOutput.this.fnsModel.put(BlockAssignment.this.varName, result);
                                break;
                            }
                            CaptureOutput.this.env.setVariable(BlockAssignment.this.varName, result);
                            break;
                        }
                        case 2: {
                            CaptureOutput.this.env.setLocalVariable(BlockAssignment.this.varName, result);
                            break;
                        }
                        case 3: {
                            CaptureOutput.this.env.setGlobalVariable(BlockAssignment.this.varName, result);
                        }
                    }
                }
            };
        }
    }
}

