/*
 * Decompiled with CFR 0.152.
 */
package org.minbox.framework.api.boot.autoconfigure.logging;

import java.util.List;
import org.minbox.framework.api.boot.autoconfigure.logging.ApiBootLoggingProperties;
import org.minbox.framework.api.boot.plugin.logging.admin.discovery.LoggingAdminDiscovery;
import org.minbox.framework.api.boot.plugin.logging.admin.discovery.support.LoggingAppointAdminDiscovery;
import org.minbox.framework.api.boot.plugin.logging.admin.discovery.support.LoggingRegistryCenterAdminDiscovery;
import org.minbox.framework.api.boot.plugin.logging.admin.report.LoggingAdminReport;
import org.minbox.framework.api.boot.plugin.logging.admin.report.LoggingReportScheduled;
import org.minbox.framework.api.boot.plugin.logging.admin.report.support.LoggingAdminReportSupport;
import org.minbox.framework.api.boot.plugin.logging.cache.LoggingCache;
import org.minbox.framework.api.boot.plugin.logging.cache.support.LoggingMemoryCache;
import org.minbox.framework.api.boot.plugin.logging.filter.ApiBootLoggingBodyFilter;
import org.minbox.framework.api.boot.plugin.logging.interceptor.ApiBootLoggingInterceptor;
import org.minbox.framework.api.boot.plugin.logging.notice.ApiBootLogNotice;
import org.minbox.framework.api.boot.plugin.logging.notice.ApiBootLoggingNoticeListener;
import org.minbox.framework.api.boot.plugin.logging.notice.away.ApiBootLogStorageNotice;
import org.minbox.framework.api.boot.plugin.logging.notice.away.support.ApiBootLoggingAdminStorageNotice;
import org.minbox.framework.api.boot.plugin.logging.notice.away.support.ApiBootLoggingLocalStorageNotice;
import org.minbox.framework.api.boot.plugin.logging.span.ApiBootLoggingSpan;
import org.minbox.framework.api.boot.plugin.logging.span.support.ApiBootLoggingDefaultSpan;
import org.minbox.framework.api.boot.plugin.logging.tracer.ApiBootLoggingTracer;
import org.minbox.framework.api.boot.plugin.logging.tracer.support.ApiBootLoggingDefaultTracer;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClient;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@ConditionalOnClass(value={ApiBootLoggingInterceptor.class})
@EnableConfigurationProperties(value={ApiBootLoggingProperties.class})
@AutoConfigureAfter(value={WebMvcAutoConfiguration.class})
@ConditionalOnWebApplication
public class ApiBootLoggingAutoConfiguration
implements WebMvcConfigurer {
    private ApiBootLoggingProperties apiBootLoggingProperties;
    private ConfigurableEnvironment environment;

    public ApiBootLoggingAutoConfiguration(ApiBootLoggingProperties apiBootLoggingProperties, ConfigurableEnvironment environment) {
        this.apiBootLoggingProperties = apiBootLoggingProperties;
        this.environment = environment;
    }

    @Bean
    @ConditionalOnMissingBean
    public ApiBootLoggingTracer apiBootLoggingTracer() {
        return new ApiBootLoggingDefaultTracer();
    }

    @Bean
    @ConditionalOnMissingBean
    public ApiBootLoggingSpan apiBootLoggingSpan() {
        return new ApiBootLoggingDefaultSpan();
    }

    @Bean
    @ConditionalOnMissingBean
    public ApiBootLoggingInterceptor apiBootLoggingInterceptor() {
        return new ApiBootLoggingInterceptor(this.environment, this.apiBootLoggingTracer(), this.apiBootLoggingSpan(), this.apiBootLoggingProperties.getIgnorePaths());
    }

    @Bean
    @ConditionalOnMissingBean
    public ApiBootLoggingBodyFilter apiBootLoggingFilter() {
        return new ApiBootLoggingBodyFilter();
    }

    @Bean
    public ApiBootLoggingNoticeListener apiBootLoggingNoticeListener(ApiBootLogStorageNotice apiBootLogStorageNotice) {
        return new ApiBootLoggingNoticeListener(apiBootLogStorageNotice, this.apiBootLoggingProperties.isFormatConsoleLogJson());
    }

    @Bean
    @ConditionalOnMissingBean(value={LoggingAdminDiscovery.class})
    public ApiBootLoggingLocalStorageNotice apiBootLoggingLocalNotice(ObjectProvider<List<ApiBootLogNotice>> localNoticeObjectProvider) {
        return new ApiBootLoggingLocalStorageNotice((List)localNoticeObjectProvider.getIfAvailable());
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={LoggingAdminDiscovery.class})
    public ApiBootLoggingAdminStorageNotice apiBootLoggingAdminStorageNotice(LoggingCache loggingCache, LoggingAdminReport loggingAdminReport) {
        return new ApiBootLoggingAdminStorageNotice(loggingCache, this.apiBootLoggingProperties.getReportAway(), loggingAdminReport);
    }

    @Bean
    @ConditionalOnProperty(prefix="api.boot.logging", name={"logging-cache-away"}, havingValue="memory", matchIfMissing=true)
    @ConditionalOnMissingBean
    public LoggingCache loggingMemoryCache() {
        return new LoggingMemoryCache();
    }

    @Bean
    @ConditionalOnMissingBean
    public LoggingAdminReport loggingAdminReportSupport(LoggingAdminDiscovery loggingAdminDiscovery, RestTemplate restTemplate, LoggingCache loggingCache, ConfigurableEnvironment environment) {
        return new LoggingAdminReportSupport(loggingAdminDiscovery, restTemplate, loggingCache, Integer.valueOf(this.apiBootLoggingProperties.getReportNumberOfRequestLog()), environment);
    }

    @Bean
    @ConditionalOnProperty(prefix="api.boot.logging", name={"report-away"}, havingValue="timing")
    @ConditionalOnMissingBean
    public LoggingReportScheduled loggingReportScheduled(LoggingAdminReport loggingAdminReport) {
        return new LoggingReportScheduled(loggingAdminReport, this.apiBootLoggingProperties.getReportInitialDelaySecond(), this.apiBootLoggingProperties.getReportIntervalSecond());
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)this.apiBootLoggingInterceptor()).addPathPatterns(this.apiBootLoggingProperties.getLoggingPathPrefix());
    }

    @Bean
    @ConditionalOnMissingBean
    public RestTemplate restTemplate() {
        return new RestTemplate();
    }

    @Configuration
    @ConditionalOnClass(value={LoadBalancerClient.class})
    @EnableConfigurationProperties(value={ApiBootLoggingProperties.class})
    @ConditionalOnProperty(prefix="api.boot.logging", name={"discovery.service-id"})
    public static class ApiBootLoggingAdminDiscoveryAutoConfiguration {
        private ApiBootLoggingProperties apiBootLoggingProperties;

        public ApiBootLoggingAdminDiscoveryAutoConfiguration(ApiBootLoggingProperties apiBootLoggingProperties) {
            this.apiBootLoggingProperties = apiBootLoggingProperties;
        }

        @Bean
        @ConditionalOnMissingBean
        public LoggingRegistryCenterAdminDiscovery loggingRegistryCenterAdminDiscovery(LoadBalancerClient loadBalancerClient) {
            return new LoggingRegistryCenterAdminDiscovery(this.apiBootLoggingProperties.getDiscovery().getServiceId(), this.apiBootLoggingProperties.getDiscovery().getUsername(), this.apiBootLoggingProperties.getDiscovery().getPassword(), loadBalancerClient);
        }
    }

    @Configuration
    @EnableConfigurationProperties(value={ApiBootLoggingProperties.class})
    @ConditionalOnMissingBean(value={LoggingRegistryCenterAdminDiscovery.class})
    @ConditionalOnProperty(prefix="api.boot.logging", name={"admin.server-address"}, matchIfMissing=true)
    public static class ApiBootLoggingAdminAppointAutoConfiguration {
        private ApiBootLoggingProperties apiBootLoggingProperties;

        public ApiBootLoggingAdminAppointAutoConfiguration(ApiBootLoggingProperties apiBootLoggingProperties) {
            this.apiBootLoggingProperties = apiBootLoggingProperties;
        }

        @Bean
        @ConditionalOnMissingBean
        public LoggingAppointAdminDiscovery loggingConfigAdminDiscovery() {
            String[] serverAddressArray = this.apiBootLoggingProperties.getAdmin().getServerAddress().split(",");
            return new LoggingAppointAdminDiscovery(serverAddressArray);
        }
    }
}

