/*
 * Decompiled with CFR 0.152.
 */
package org.minbox.framework.api.boot.autoconfigure.logging.admin;

import javax.sql.DataSource;
import org.minbox.framework.api.boot.autoconfigure.logging.admin.ApiBootLoggingAdminProperties;
import org.minbox.framework.api.boot.plugin.logging.admin.endpoint.LoggingEndpoint;
import org.minbox.framework.api.boot.plugin.logging.admin.endpoint.LoggingRequestMappingHandlerMapping;
import org.minbox.framework.api.boot.plugin.logging.admin.listener.ReportLogJsonFormatListener;
import org.minbox.framework.api.boot.plugin.logging.admin.listener.ReportLogStorageListener;
import org.minbox.framework.api.boot.plugin.logging.admin.storage.LoggingDataSourceStorage;
import org.minbox.framework.api.boot.plugin.logging.admin.storage.LoggingStorage;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerMapping;

@Configuration
@ConditionalOnClass(value={LoggingEndpoint.class})
@ConditionalOnWebApplication
@EnableConfigurationProperties(value={ApiBootLoggingAdminProperties.class})
@AutoConfigureAfter(value={DataSourceAutoConfiguration.class})
public class ApiBootLoggingAdminAutoConfiguration {
    private ApiBootLoggingAdminProperties apiBootLoggingAdminProperties;

    public ApiBootLoggingAdminAutoConfiguration(ApiBootLoggingAdminProperties apiBootLoggingAdminProperties) {
        this.apiBootLoggingAdminProperties = apiBootLoggingAdminProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    public LoggingEndpoint loggingEndpoint() {
        return new LoggingEndpoint();
    }

    @Bean
    public HandlerMapping loggingRequestMappingHandlerMapping() {
        return new LoggingRequestMappingHandlerMapping((Object)this.loggingEndpoint());
    }

    @Bean
    @ConditionalOnMissingBean
    public ReportLogJsonFormatListener reportLogJsonFormatListener() {
        return new ReportLogJsonFormatListener(this.apiBootLoggingAdminProperties.isShowConsoleReportLog(), this.apiBootLoggingAdminProperties.isFormatConsoleLogJson());
    }

    @Configuration
    @ConditionalOnBean(value={DataSource.class})
    public static class StorageLogAutoConfiguration {
        @Bean
        @ConditionalOnMissingBean
        public LoggingStorage loggingStorage(DataSource dataSource) {
            return new LoggingDataSourceStorage(dataSource);
        }

        @Bean
        @ConditionalOnMissingBean
        public ReportLogStorageListener reportLogStorageListener(LoggingStorage loggingStorage) {
            return new ReportLogStorageListener(loggingStorage);
        }
    }
}

