/*
 * Decompiled with CFR 0.152.
 */
package org.minbox.framework.api.boot.autoconfigure.mail;

import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import org.minbox.framework.api.boot.autoconfigure.mail.ApiBootMailProperties;
import org.minbox.framework.api.boot.plugin.mail.ApiBootAliYunMailService;
import org.minbox.framework.api.boot.plugin.mail.ApiBootMailService;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={ApiBootAliYunMailService.class})
@ConditionalOnProperty(prefix="api.boot.mail", name={"access-key", "access-secret", "account-name", "region"})
@EnableConfigurationProperties(value={ApiBootMailProperties.class})
public class ApiBootMailAutoConfiguration {
    private ApiBootMailProperties apiBootMailProperties;

    public ApiBootMailAutoConfiguration(ApiBootMailProperties apiBootMailProperties) {
        this.apiBootMailProperties = apiBootMailProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    public ApiBootMailService apiBootMailService(IAcsClient acsClient) {
        return new ApiBootAliYunMailService(acsClient, this.apiBootMailProperties.getAccountName(), this.apiBootMailProperties.isReplyToAddress(), this.apiBootMailProperties.getAddressType(), this.apiBootMailProperties.getFromAlias(), this.apiBootMailProperties.getTagName());
    }

    @Bean
    @ConditionalOnMissingBean
    public IAcsClient acsClient() {
        DefaultProfile profile = DefaultProfile.getProfile((String)this.apiBootMailProperties.getRegion().getValue(), (String)this.apiBootMailProperties.getAccessKey(), (String)this.apiBootMailProperties.getAccessSecret());
        return new DefaultAcsClient((IClientProfile)profile);
    }
}

