/*
 * Decompiled with CFR 0.152.
 */
package org.minbox.framework.api.boot.autoconfigure.oauth;

import java.util.List;
import javax.sql.DataSource;
import org.minbox.framework.api.boot.autoconfigure.oauth.ApiBootAuthorizationServerAutoConfiguration;
import org.minbox.framework.api.boot.autoconfigure.oauth.ApiBootOauthProperties;
import org.minbox.framework.api.boot.plugin.oauth.ApiBootAuthorizationServerConfiguration;
import org.minbox.framework.api.boot.plugin.oauth.grant.ApiBootOauthTokenGranter;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.oauth2.config.annotation.configurers.ClientDetailsServiceConfigurer;
import org.springframework.security.oauth2.config.annotation.web.configuration.EnableAuthorizationServer;
import org.springframework.security.oauth2.provider.token.TokenStore;
import org.springframework.security.oauth2.provider.token.store.JdbcTokenStore;

@Configuration
@EnableConfigurationProperties(value={ApiBootOauthProperties.class})
@EnableAuthorizationServer
@ConditionalOnBean(value={DataSource.class})
@ConditionalOnClass(value={ApiBootAuthorizationServerConfiguration.class})
@ConditionalOnProperty(prefix="api.boot.oauth", name={"away"}, havingValue="jdbc")
@AutoConfigureAfter(value={DataSourceAutoConfiguration.class})
public class ApiBootAuthorizationServerJdbcAutoConfiguration
extends ApiBootAuthorizationServerAutoConfiguration {
    private DataSource dataSource;

    public ApiBootAuthorizationServerJdbcAutoConfiguration(ObjectProvider<List<ApiBootOauthTokenGranter>> objectProvider, ApiBootOauthProperties apiBootOauthProperties, DataSource dataSource) {
        super(objectProvider, apiBootOauthProperties);
        this.dataSource = dataSource;
    }

    public void configure(ClientDetailsServiceConfigurer clients) throws Exception {
        clients.jdbc(this.dataSource);
    }

    @Bean
    public TokenStore jdbcTokenStore() {
        return new JdbcTokenStore(this.dataSource);
    }
}

