/*
 * Decompiled with CFR 0.152.
 */
package org.minbox.framework.api.boot.autoconfigure.oauth;

import org.minbox.framework.api.boot.autoconfigure.oauth.ApiBootOauthProperties;
import org.minbox.framework.api.boot.autoconfigure.security.ApiBootSecurityProperties;
import org.minbox.framework.api.boot.plugin.security.SecurityUser;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.oauth2.config.annotation.web.configuration.EnableResourceServer;
import org.springframework.security.oauth2.config.annotation.web.configuration.ResourceServerConfigurerAdapter;
import org.springframework.security.oauth2.config.annotation.web.configurers.ResourceServerSecurityConfigurer;

@Configuration
@ConditionalOnClass(value={ResourceServerConfigurerAdapter.class, SecurityUser.class})
@EnableConfigurationProperties(value={ApiBootSecurityProperties.class, ApiBootOauthProperties.class})
@EnableResourceServer
public class ApiBootResourceServerAutoConfiguration
extends ResourceServerConfigurerAdapter {
    private ApiBootSecurityProperties apiBootSecurityProperties;
    private ApiBootOauthProperties apiBootOauthProperties;

    public ApiBootResourceServerAutoConfiguration(ApiBootSecurityProperties apiBootSecurityProperties, ApiBootOauthProperties apiBootOauthProperties) {
        this.apiBootSecurityProperties = apiBootSecurityProperties;
        this.apiBootOauthProperties = apiBootOauthProperties;
    }

    public void configure(HttpSecurity http) throws Exception {
        ((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().anyRequest()).authenticated().and()).requestMatchers().antMatchers(this.apiBootSecurityProperties.getAuthPrefix());
    }

    public void configure(ResourceServerSecurityConfigurer resources) throws Exception {
        resources.resourceId(this.apiBootOauthProperties.getResourceId());
    }
}

