/*
 * Decompiled with CFR 0.152.
 */
package org.minbox.framework.api.boot.autoconfigure.oss;

import com.aliyun.oss.OSSClient;
import org.minbox.framework.api.boot.autoconfigure.oss.ApiBootOssProperties;
import org.minbox.framework.api.boot.plugin.oss.ApiBootOssService;
import org.minbox.framework.api.boot.plugin.oss.progress.ApiBootObjectStorageProgress;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={ApiBootOssProperties.class})
@ConditionalOnClass(value={OSSClient.class})
@ConditionalOnProperty(prefix="api.boot.oss", name={"region", "access-key-id", "access-key-secret", "bucket-name"})
public class ApiBootOssAutoConfiguration {
    private ApiBootOssProperties apiBootOssProperties;
    private ApiBootObjectStorageProgress apiBootObjectStorageProgress;

    public ApiBootOssAutoConfiguration(ApiBootOssProperties apiBootOssProperties, ObjectProvider<ApiBootObjectStorageProgress> apiBootProgressProvider) {
        this.apiBootOssProperties = apiBootOssProperties;
        this.apiBootObjectStorageProgress = (ApiBootObjectStorageProgress)apiBootProgressProvider.getIfAvailable();
    }

    @Bean
    @ConditionalOnMissingBean
    ApiBootOssService apiBootOssService() {
        ApiBootOssService apiBootOssService = new ApiBootOssService(this.apiBootOssProperties.getRegion().getEndpoint(), this.apiBootOssProperties.getBucketName(), this.apiBootOssProperties.getAccessKeyId(), this.apiBootOssProperties.getAccessKeySecret(), this.apiBootOssProperties.getDomain());
        apiBootOssService.setApiBootObjectStorageProgress(this.apiBootObjectStorageProgress);
        return apiBootOssService;
    }
}

