/*
 * Decompiled with CFR 0.152.
 */
package org.minbox.framework.api.boot.autoconfigure.resource;

import org.minbox.framework.api.boot.plugin.resource.load.ApiBootResourceStoreDelegate;
import org.minbox.framework.api.boot.plugin.resource.load.pusher.support.ApiBootRedisResourcePusher;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.core.RedisTemplate;

@Configuration
@ConditionalOnClass(value={RedisTemplate.class})
@AutoConfigureAfter(value={RedisAutoConfiguration.class})
public class ApiBootResourceRedisLoadAutoConfiguration {
    private ApiBootResourceStoreDelegate resourceStoreDelegate;

    public ApiBootResourceRedisLoadAutoConfiguration(ObjectProvider<ApiBootResourceStoreDelegate> resourceStoreDelegateObjectProvider) {
        this.resourceStoreDelegate = (ApiBootResourceStoreDelegate)resourceStoreDelegateObjectProvider.getIfAvailable();
    }

    @Bean
    @ConditionalOnMissingBean
    ApiBootRedisResourcePusher apiBootRedisResourcePusher(RedisTemplate redisTemplate) {
        return new ApiBootRedisResourcePusher(this.resourceStoreDelegate, redisTemplate);
    }
}

