/*
 * Decompiled with CFR 0.152.
 */
package org.minbox.framework.api.boot.autoconfigure.security;

import javax.sql.DataSource;
import org.minbox.framework.api.boot.autoconfigure.security.ApiBootSecurityProperties;
import org.minbox.framework.api.boot.autoconfigure.security.ApiBootWebSecurityAutoConfiguration;
import org.minbox.framework.api.boot.plugin.security.ApiBootWebSecurityConfiguration;
import org.minbox.framework.api.boot.plugin.security.delegate.ApiBootDefaultStoreDelegate;
import org.minbox.framework.api.boot.plugin.security.delegate.ApiBootStoreDelegate;
import org.minbox.framework.api.boot.plugin.security.userdetails.ApiBootUserDetailsService;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.access.AccessDeniedHandler;

@Configuration
@EnableWebSecurity
@EnableGlobalMethodSecurity(prePostEnabled=true)
@EnableConfigurationProperties(value={ApiBootSecurityProperties.class})
@ConditionalOnClass(value={ApiBootWebSecurityConfiguration.class})
@ConditionalOnBean(value={DataSource.class})
@ConditionalOnProperty(prefix="api.boot.security", name={"away"}, havingValue="jdbc")
@AutoConfigureAfter(value={DataSourceAutoConfiguration.class})
public class ApiBootWebSecurityJdbcAutoConfiguration
extends ApiBootWebSecurityAutoConfiguration {
    public ApiBootWebSecurityJdbcAutoConfiguration(ApiBootSecurityProperties apiBootSecurityProperties, ObjectProvider<AccessDeniedHandler> accessDeniedHandler, ObjectProvider<AuthenticationEntryPoint> authenticationEntryPoint) {
        super(apiBootSecurityProperties, (AccessDeniedHandler)accessDeniedHandler.getIfAvailable(), (AuthenticationEntryPoint)authenticationEntryPoint.getIfAvailable());
    }

    @Bean
    protected UserDetailsService userDetailsService() {
        return new ApiBootUserDetailsService();
    }

    @Bean
    @ConditionalOnProperty(prefix="api.boot.security", name={"enable-default-store-delegate"}, havingValue="true", matchIfMissing=true)
    public ApiBootStoreDelegate apiBootStoreDelegate(DataSource dataSource) {
        return new ApiBootDefaultStoreDelegate(dataSource);
    }
}

