/*
 * Decompiled with CFR 0.152.
 */
package org.minbox.framework.api.boot.autoconfigure.security;

import java.util.List;
import org.minbox.framework.api.boot.autoconfigure.security.ApiBootSecurityProperties;
import org.minbox.framework.api.boot.autoconfigure.security.ApiBootWebSecurityAutoConfiguration;
import org.minbox.framework.api.boot.plugin.security.ApiBootWebSecurityConfiguration;
import org.minbox.framework.api.boot.plugin.security.SecurityUser;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.provisioning.InMemoryUserDetailsManager;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.util.ObjectUtils;

@Configuration
@EnableWebSecurity
@EnableGlobalMethodSecurity(prePostEnabled=true)
@EnableConfigurationProperties(value={ApiBootSecurityProperties.class})
@ConditionalOnClass(value={ApiBootWebSecurityConfiguration.class})
@ConditionalOnProperty(prefix="api.boot.security", name={"away"}, havingValue="memory", matchIfMissing=true)
public class ApiBootWebSecurityMemoryAutoConfiguration
extends ApiBootWebSecurityAutoConfiguration {
    public ApiBootWebSecurityMemoryAutoConfiguration(ApiBootSecurityProperties apiBootSecurityProperties, ObjectProvider<AccessDeniedHandler> accessDeniedHandler, ObjectProvider<AuthenticationEntryPoint> authenticationEntryPoint) {
        super(apiBootSecurityProperties, (AccessDeniedHandler)accessDeniedHandler.getIfAvailable(), (AuthenticationEntryPoint)authenticationEntryPoint.getIfAvailable());
    }

    @Bean
    protected UserDetailsService userDetailsService() {
        InMemoryUserDetailsManager memoryUserDetails = new InMemoryUserDetailsManager();
        List<SecurityUser> users = this.apiBootSecurityProperties.getUsers();
        if (!ObjectUtils.isEmpty(users)) {
            for (SecurityUser securityUser : users) {
                memoryUserDetails.createUser(User.builder().username(securityUser.getUsername()).password(this.passwordEncoder().encode((CharSequence)securityUser.getPassword())).roles(securityUser.getRoles()).build());
            }
        }
        return memoryUserDetails;
    }
}

