/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.socket.tls;

import java.lang.reflect.Constructor;
import org.mockserver.configuration.ConfigurationProperties;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.socket.tls.KeyAndCertificateFactory;
import org.mockserver.socket.tls.jdk.JDKKeyAndCertificateFactory;
import org.slf4j.event.Level;

public class KeyAndCertificateFactoryFactory {
    private static final ClassLoader CLASS_LOADER = KeyAndCertificateFactoryFactory.class.getClassLoader();

    public static KeyAndCertificateFactory createKeyAndCertificateFactory(MockServerLogger mockServerLogger) {
        if (ConfigurationProperties.useBouncyCastleForKeyAndCertificateGeneration()) {
            Class<?> bouncyCastleProvider = null;
            Class<?> bouncyCastleX509Holder = null;
            try {
                bouncyCastleProvider = CLASS_LOADER.loadClass("org.bouncycastle.jce.provider.BouncyCastleProvider");
                bouncyCastleX509Holder = CLASS_LOADER.loadClass("org.bouncycastle.cert.X509CertificateHolder");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (bouncyCastleProvider == null || bouncyCastleX509Holder == null) {
                mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("failed to instantiate the BouncyCastle KeyAndCertificateFactory because BouncyCastle library is not available in classpath please ensure the following dependencies are available").setArguments("<dependency>\n    <groupId>org.bouncycastle</groupId>\n    <artifactId>bcprov-jdk15on</artifactId>\n    <version>1.67</version>\n</dependency>\n<dependency>\n    <groupId>org.bouncycastle</groupId>\n    <artifactId>bcpkix-jdk15on</artifactId>\n    <version>1.67</version>\n</dependency>"));
            }
            try {
                Class<?> keyAndCertificateFactorClass = CLASS_LOADER.loadClass("org.mockserver.socket.tls.bouncycastle.BCKeyAndCertificateFactory");
                Constructor<?> keyAndCertificateFactorConstructor = keyAndCertificateFactorClass.getDeclaredConstructor(MockServerLogger.class);
                if (MockServerLogger.isEnabled(Level.INFO)) {
                    mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.INFO).setMessageFormat("using Bouncy Castle for X.509 Certificate and Private Key generation"));
                }
                return (KeyAndCertificateFactory)keyAndCertificateFactorConstructor.newInstance(mockServerLogger);
            }
            catch (Throwable throwable) {
                mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("failed to instantiate the BouncyCastle KeyAndCertificateFactory").setThrowable(throwable));
                return null;
            }
        }
        return new JDKKeyAndCertificateFactory(mockServerLogger);
    }
}

