/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.invocation;

import java.lang.reflect.Method;
import java.util.Arrays;
import org.mockito.internal.exceptions.Reporter;
import org.mockito.internal.exceptions.VerificationAwareInvocation;
import org.mockito.internal.invocation.ArgumentsProcessor;
import org.mockito.internal.invocation.MockitoMethod;
import org.mockito.internal.invocation.realmethod.RealMethod;
import org.mockito.internal.reporting.PrintSettings;
import org.mockito.invocation.Invocation;
import org.mockito.invocation.Location;
import org.mockito.invocation.StubInfo;

public class InvocationImpl
implements Invocation,
VerificationAwareInvocation {
    private static final long serialVersionUID = 8240069639250980199L;
    private final int sequenceNumber;
    private final Object mock;
    private final MockitoMethod method;
    private final Object[] arguments;
    private final Object[] rawArguments;
    private final Location location;
    private boolean verified;
    private boolean isIgnoredForVerification;
    final RealMethod realMethod;
    private StubInfo stubInfo;

    public InvocationImpl(Object mock, MockitoMethod mockitoMethod, Object[] args, int sequenceNumber, RealMethod realMethod, Location location) {
        this.method = mockitoMethod;
        this.mock = mock;
        this.realMethod = realMethod;
        this.arguments = ArgumentsProcessor.expandArgs(mockitoMethod, args);
        this.rawArguments = args;
        this.sequenceNumber = sequenceNumber;
        this.location = location;
    }

    @Override
    public Object getMock() {
        return this.mock;
    }

    @Override
    public Method getMethod() {
        return this.method.getJavaMethod();
    }

    @Override
    public Object[] getArguments() {
        return this.arguments;
    }

    @Override
    public <T> T getArgument(int index) {
        return (T)this.arguments[index];
    }

    @Override
    public boolean isVerified() {
        return this.verified || this.isIgnoredForVerification;
    }

    @Override
    public int getSequenceNumber() {
        return this.sequenceNumber;
    }

    public boolean equals(Object o) {
        if (o == null || !o.getClass().equals(this.getClass())) {
            return false;
        }
        InvocationImpl other = (InvocationImpl)o;
        return this.mock.equals(other.mock) && this.method.equals(other.method) && this.equalArguments(other.arguments);
    }

    private boolean equalArguments(Object[] arguments) {
        return Arrays.equals(arguments, this.arguments);
    }

    public int hashCode() {
        return 1;
    }

    @Override
    public String toString() {
        return new PrintSettings().print(ArgumentsProcessor.argumentsToMatchers(this.getArguments()), this);
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    @Override
    public Object[] getRawArguments() {
        return this.rawArguments;
    }

    @Override
    public Class<?> getRawReturnType() {
        return this.method.getReturnType();
    }

    @Override
    public Object callRealMethod() throws Throwable {
        if (this.method.isAbstract()) {
            throw Reporter.cannotCallAbstractRealMethod();
        }
        return this.realMethod.invoke(this.mock, this.rawArguments);
    }

    @Override
    public void markVerified() {
        this.verified = true;
    }

    @Override
    public StubInfo stubInfo() {
        return this.stubInfo;
    }

    @Override
    public void markStubbed(StubInfo stubInfo) {
        this.stubInfo = stubInfo;
    }

    @Override
    public boolean isIgnoredForVerification() {
        return this.isIgnoredForVerification;
    }

    @Override
    public void ignoreForVerification() {
        this.isIgnoredForVerification = true;
    }
}

